/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.karaf.shell.api.console.Command;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.apache.karaf.shell.support.completers.AggregateCompleter;
import org.apache.karaf.shell.support.completers.ArgumentCommandLine;
import org.apache.karaf.shell.support.completers.StringsCompleter;

public class CommandsCompleter
extends org.apache.karaf.shell.support.completers.CommandsCompleter {
    private final SessionFactory factory;
    private final Map<String, Completer> globalCompleters = new HashMap<String, Completer>();
    private final Map<String, Completer> localCompleters = new HashMap<String, Completer>();
    private final Completer aliasesCompleter = new SimpleCommandCompleter(){

        @Override
        protected Collection<String> getNames(Session session) {
            return CommandsCompleter.this.getAliases(session);
        }
    };
    private final List<Command> commands = new ArrayList<Command>();

    public CommandsCompleter(SessionFactory factory) {
        this.factory = factory;
    }

    @Override
    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        Map<String, Completer>[] allCompleters = this.checkData();
        List<String> scopes = this.getCurrentScopes(session);
        this.sort(allCompleters, scopes);
        String subShell = this.getCurrentSubShell(session);
        String completion = this.getCompletionType(session);
        if ("subshell".equalsIgnoreCase(completion)) {
            if (subShell.isEmpty()) {
                subShell = "*";
            }
            ArrayList<Completer> completers = new ArrayList<Completer>();
            for (String name : allCompleters[1].keySet()) {
                if (!name.startsWith(subShell + ":")) continue;
                completers.add(allCompleters[1].get(name));
            }
            if (!subShell.equals("*")) {
                completers.add(new StringsCompleter(new String[]{"exit"}));
            }
            int res = new AggregateCompleter(completers).complete(session, commandLine, (List)candidates);
            Collections.sort(candidates);
            return res;
        }
        if ("first".equalsIgnoreCase(completion)) {
            int res;
            if (!subShell.isEmpty()) {
                ArrayList<Completer> completers = new ArrayList<Completer>();
                for (String name : allCompleters[1].keySet()) {
                    if (!name.startsWith(subShell + ":")) continue;
                    completers.add(allCompleters[1].get(name));
                }
                res = new AggregateCompleter(completers).complete(session, commandLine, (List)candidates);
                if (!candidates.isEmpty()) {
                    Collections.sort(candidates);
                    return res;
                }
            }
            ArrayList<Completer> compl = new ArrayList<Completer>();
            compl.add(this.aliasesCompleter);
            compl.addAll(allCompleters[0].values());
            res = new AggregateCompleter(compl).complete(session, commandLine, (List)candidates);
            Collections.sort(candidates);
            return res;
        }
        ArrayList<Completer> compl = new ArrayList<Completer>();
        compl.add(this.aliasesCompleter);
        compl.addAll(allCompleters[0].values());
        int res = new AggregateCompleter(compl).complete(session, commandLine, (List)candidates);
        Collections.sort(candidates);
        return res;
    }

    protected void sort(Map<String, Completer>[] completers, List<String> scopes) {
        ScopeComparator comparator = new ScopeComparator(scopes);
        for (int i = 0; i < completers.length; ++i) {
            TreeMap<String, Completer> map = new TreeMap<String, Completer>(comparator);
            map.putAll(completers[i]);
            completers[i] = map;
        }
    }

    protected List<String> getCurrentScopes(Session session) {
        String scopes = (String)session.get("SCOPE");
        return Arrays.asList(scopes.split(":"));
    }

    protected String getCurrentSubShell(Session session) {
        String s = (String)session.get("SUBSHELL");
        if (s == null) {
            s = "";
        }
        return s;
    }

    protected String getCompletionType(Session session) {
        String completion = (String)session.get("karaf.completionMode");
        if (completion == null) {
            completion = "global";
        }
        return completion;
    }

    protected String stripScope(String name) {
        int index = name.indexOf(":");
        return index > 0 ? name.substring(index + 1) : name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Completer>[] checkData() {
        boolean update;
        List<Command> commands;
        CommandsCompleter commandsCompleter = this;
        synchronized (commandsCompleter) {
            commands = this.factory.getRegistry().getCommands();
            update = !commands.equals(this.commands);
        }
        if (update) {
            HashMap<String, Completer> global = new HashMap<String, Completer>();
            HashMap<String, Completer> local = new HashMap<String, Completer>();
            for (Command command : commands) {
                String key = command.getScope() + ":" + command.getName();
                Completer cg = command.getCompleter(false);
                Completer cl = command.getCompleter(true);
                if (cg == null) {
                    cg = "*".equals(command.getScope()) ? new FixedSimpleCommandCompleter(Arrays.asList(command.getName())) : new FixedSimpleCommandCompleter(Arrays.asList(key, command.getName()));
                }
                if (cl == null) {
                    cl = new FixedSimpleCommandCompleter(Arrays.asList(command.getName()));
                }
                global.put(key, cg);
                local.put(key, cl);
            }
            CommandsCompleter commandsCompleter2 = this;
            synchronized (commandsCompleter2) {
                this.commands.clear();
                this.globalCompleters.clear();
                this.localCompleters.clear();
                this.commands.addAll(commands);
                this.globalCompleters.putAll(global);
                this.localCompleters.putAll(local);
            }
        }
        commandsCompleter = this;
        synchronized (commandsCompleter) {
            return new Map[]{new HashMap<String, Completer>(this.globalCompleters), new HashMap<String, Completer>(this.localCompleters)};
        }
    }

    private Set<String> getAliases(Session session) {
        Set vars = (Set)session.get(null);
        HashSet<String> aliases = new HashSet<String>();
        for (String var : vars) {
            Object content = session.get(var);
            if (content == null || !"org.apache.felix.gogo.runtime.Closure".equals(content.getClass().getName())) continue;
            aliases.add(var);
        }
        return aliases;
    }

    static class FixedSimpleCommandCompleter
    extends SimpleCommandCompleter {
        private final Collection<String> names;

        FixedSimpleCommandCompleter(Collection<String> names) {
            this.names = names;
        }

        @Override
        protected Collection<String> getNames(Session session) {
            return this.names;
        }
    }

    static abstract class SimpleCommandCompleter
    implements Completer {
        SimpleCommandCompleter() {
        }

        @Override
        public int complete(Session session, CommandLine commandLine, List<String> candidates) {
            String[] args = commandLine.getArguments();
            int argIndex = commandLine.getCursorArgumentIndex();
            StringsCompleter completer = new StringsCompleter(this.getNames(session));
            if (argIndex == 0) {
                int res = completer.complete(session, new ArgumentCommandLine(args[argIndex], commandLine.getArgumentPosition()), candidates);
                if (res > -1) {
                    res += commandLine.getBufferPosition() - commandLine.getArgumentPosition();
                }
                return res;
            }
            if (!this.verifyCompleter(session, completer, args[0])) {
                return -1;
            }
            return 0;
        }

        protected abstract Collection<String> getNames(Session var1);

        private boolean verifyCompleter(Session session, Completer completer, String argument) {
            ArrayList<String> candidates = new ArrayList<String>();
            return completer.complete(session, new ArgumentCommandLine(argument, argument.length()), candidates) != -1 && !candidates.isEmpty();
        }
    }

    protected static class ScopeComparator
    implements Comparator<String> {
        private final List<String> scopes;

        public ScopeComparator(List<String> scopes) {
            this.scopes = scopes;
        }

        @Override
        public int compare(String o1, String o2) {
            String[] p1 = o1.split(":");
            String[] p2 = o2.split(":");
            int p = 0;
            while (p < p1.length && p < p2.length) {
                int i1 = this.scopes.indexOf(p1[p]);
                int i2 = this.scopes.indexOf(p2[p]);
                if (i1 < 0) {
                    if (i2 < 0) {
                        int c = p1[p].compareTo(p2[p]);
                        if (c != 0) {
                            return c;
                        }
                        ++p;
                        continue;
                    }
                    return 1;
                }
                if (i2 < 0) {
                    return -1;
                }
                if (i1 < i2) {
                    return -1;
                }
                if (i1 > i2) {
                    return 1;
                }
                ++p;
            }
            return 0;
        }
    }
}

