/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.registry;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.felix.http.base.internal.handler.ListenerHandler;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.base.internal.registry.ListenerMap;
import org.apache.felix.http.base.internal.runtime.ListenerInfo;
import org.osgi.service.http.runtime.dto.FailedListenerDTO;
import org.osgi.service.http.runtime.dto.ListenerDTO;
import org.osgi.service.http.runtime.dto.ServletContextDTO;

public final class EventListenerRegistry
implements HttpSessionListener,
HttpSessionAttributeListener,
HttpSessionIdListener,
ServletContextAttributeListener,
ServletRequestListener,
ServletRequestAttributeListener {
    private final ListenerMap<ServletContextListener> contextListeners = new ListenerMap();
    private final ListenerMap<ServletContextAttributeListener> contextAttributeListeners = new ListenerMap();
    private final ListenerMap<HttpSessionAttributeListener> sessionAttributeListeners = new ListenerMap();
    private final ListenerMap<HttpSessionListener> sessionListeners = new ListenerMap();
    private final ListenerMap<HttpSessionIdListener> sessionIdListeners = new ListenerMap();
    private final ListenerMap<ServletRequestListener> requestListeners = new ListenerMap();
    private final ListenerMap<ServletRequestAttributeListener> requestAttributeListeners = new ListenerMap();

    public void cleanup() {
        this.contextListeners.cleanup();
        this.contextAttributeListeners.cleanup();
        this.sessionAttributeListeners.cleanup();
        this.sessionListeners.cleanup();
        this.sessionIdListeners.cleanup();
        this.requestListeners.cleanup();
        this.requestAttributeListeners.cleanup();
    }

    public void addListeners(@Nonnull ListenerHandler handler) {
        int reason = handler.init();
        if (handler.getListenerInfo().isListenerType(ServletContextListener.class.getName())) {
            this.contextListeners.add(handler, reason);
        }
        if (handler.getListenerInfo().isListenerType(ServletContextAttributeListener.class.getName())) {
            this.contextAttributeListeners.add(handler, reason);
        }
        if (handler.getListenerInfo().isListenerType(HttpSessionListener.class.getName())) {
            this.sessionListeners.add(handler, reason);
        }
        if (handler.getListenerInfo().isListenerType(HttpSessionIdListener.class.getName())) {
            this.sessionIdListeners.add(handler, reason);
        }
        if (handler.getListenerInfo().isListenerType(HttpSessionAttributeListener.class.getName())) {
            this.sessionAttributeListeners.add(handler, reason);
        }
        if (handler.getListenerInfo().isListenerType(ServletRequestListener.class.getName())) {
            this.requestListeners.add(handler, reason);
        }
        if (handler.getListenerInfo().isListenerType(ServletRequestAttributeListener.class.getName())) {
            this.requestAttributeListeners.add(handler, reason);
        }
    }

    public void removeListeners(@Nonnull ListenerInfo info) {
        ListenerHandler handler = null;
        if (info.isListenerType(ServletContextListener.class.getName())) {
            handler = this.contextListeners.remove(info);
        }
        if (info.isListenerType(ServletContextAttributeListener.class.getName())) {
            handler = this.contextAttributeListeners.remove(info);
        }
        if (info.isListenerType(HttpSessionListener.class.getName())) {
            handler = this.sessionListeners.remove(info);
        }
        if (info.isListenerType(HttpSessionIdListener.class.getName())) {
            handler = this.sessionIdListeners.remove(info);
        }
        if (info.isListenerType(HttpSessionAttributeListener.class.getName())) {
            handler = this.sessionAttributeListeners.remove(info);
        }
        if (info.isListenerType(ServletRequestListener.class.getName())) {
            handler = this.requestListeners.remove(info);
        }
        if (info.isListenerType(ServletRequestAttributeListener.class.getName())) {
            handler = this.requestAttributeListeners.remove(info);
        }
        if (handler != null) {
            handler.destroy();
        }
    }

    @CheckForNull
    public ListenerHandler getServletContextListener(@Nonnull ListenerInfo info) {
        return this.contextListeners.getListenerHandler(info);
    }

    public void contextInitialized() {
        for (ListenerHandler l : this.contextListeners.getActiveHandlers()) {
            ServletContextListener listener = (ServletContextListener)l.getListener();
            if (listener == null) continue;
            EventListenerRegistry.contextInitialized(l.getListenerInfo(), listener, new ServletContextEvent((ServletContext)l.getContext()));
        }
    }

    public void contextDestroyed() {
        for (ListenerHandler l : this.contextListeners.getActiveHandlers()) {
            ServletContextListener listener = (ServletContextListener)l.getListener();
            if (listener == null) continue;
            EventListenerRegistry.contextDestroyed(l.getListenerInfo(), listener, new ServletContextEvent((ServletContext)l.getContext()));
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        for (HttpSessionAttributeListener l : this.sessionAttributeListeners.getActiveListeners()) {
            try {
                l.attributeReplaced(event);
            }
            catch (Throwable t) {
                SystemLogger.error(null, "Exception while calling listener " + l, t);
            }
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        for (HttpSessionAttributeListener l : this.sessionAttributeListeners.getActiveListeners()) {
            try {
                l.attributeRemoved(event);
            }
            catch (Throwable t) {
                SystemLogger.error(null, "Exception while calling listener " + l, t);
            }
        }
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
        for (HttpSessionAttributeListener l : this.sessionAttributeListeners.getActiveListeners()) {
            try {
                l.attributeAdded(event);
            }
            catch (Throwable t) {
                SystemLogger.error(null, "Exception while calling listener " + l, t);
            }
        }
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
        for (ServletContextAttributeListener l : this.contextAttributeListeners.getActiveListeners()) {
            try {
                l.attributeReplaced(event);
            }
            catch (Throwable t) {
                SystemLogger.error(null, "Exception while calling listener " + l, t);
            }
        }
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
        for (ServletContextAttributeListener l : this.contextAttributeListeners.getActiveListeners()) {
            try {
                l.attributeRemoved(event);
            }
            catch (Throwable t) {
                SystemLogger.error(null, "Exception while calling listener " + l, t);
            }
        }
    }

    public void attributeAdded(ServletContextAttributeEvent event) {
        for (ServletContextAttributeListener l : this.contextAttributeListeners.getActiveListeners()) {
            try {
                l.attributeAdded(event);
            }
            catch (Throwable t) {
                SystemLogger.error(null, "Exception while calling listener " + l, t);
            }
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
        for (HttpSessionListener l : this.sessionListeners.getActiveListeners()) {
            try {
                l.sessionCreated(se);
            }
            catch (Throwable t) {
                SystemLogger.error(null, "Exception while calling listener " + l, t);
            }
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        for (HttpSessionListener l : this.sessionListeners.getActiveListeners()) {
            try {
                l.sessionDestroyed(se);
            }
            catch (Throwable t) {
                SystemLogger.error(null, "Exception while calling listener " + l, t);
            }
        }
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        for (ServletRequestListener l : this.requestListeners.getActiveListeners()) {
            try {
                l.requestDestroyed(sre);
            }
            catch (Throwable t) {
                SystemLogger.error(null, "Exception while calling listener " + l, t);
            }
        }
    }

    public void requestInitialized(ServletRequestEvent sre) {
        for (ServletRequestListener l : this.requestListeners.getActiveListeners()) {
            try {
                l.requestInitialized(sre);
            }
            catch (Throwable t) {
                SystemLogger.error(null, "Exception while calling listener " + l, t);
            }
        }
    }

    public void attributeAdded(ServletRequestAttributeEvent srae) {
        for (ServletRequestAttributeListener l : this.requestAttributeListeners.getActiveListeners()) {
            try {
                l.attributeAdded(srae);
            }
            catch (Throwable t) {
                SystemLogger.error(null, "Exception while calling listener " + l, t);
            }
        }
    }

    public void attributeRemoved(ServletRequestAttributeEvent srae) {
        for (ServletRequestAttributeListener l : this.requestAttributeListeners.getActiveListeners()) {
            try {
                l.attributeRemoved(srae);
            }
            catch (Throwable t) {
                SystemLogger.error(null, "Exception while calling listener " + l, t);
            }
        }
    }

    public void attributeReplaced(ServletRequestAttributeEvent srae) {
        for (ServletRequestAttributeListener l : this.requestAttributeListeners.getActiveListeners()) {
            try {
                l.attributeReplaced(srae);
            }
            catch (Throwable t) {
                SystemLogger.error(null, "Exception while calling listener " + l, t);
            }
        }
    }

    public void sessionIdChanged(@Nonnull HttpSessionEvent event, @Nonnull String oldSessionId) {
        for (HttpSessionIdListener l : this.sessionIdListeners.getActiveListeners()) {
            try {
                l.sessionIdChanged(event, oldSessionId);
            }
            catch (Throwable t) {
                SystemLogger.error(null, "Exception while calling listener " + l, t);
            }
        }
    }

    public void getRuntimeInfo(ServletContextDTO dto, List<FailedListenerDTO> failedListenerDTOs) {
        ArrayList<ListenerDTO> listenerDTOs = new ArrayList<ListenerDTO>();
        this.contextListeners.getRuntimeInfo(listenerDTOs, failedListenerDTOs);
        this.contextAttributeListeners.getRuntimeInfo(listenerDTOs, failedListenerDTOs);
        this.requestListeners.getRuntimeInfo(listenerDTOs, failedListenerDTOs);
        this.requestAttributeListeners.getRuntimeInfo(listenerDTOs, failedListenerDTOs);
        this.sessionListeners.getRuntimeInfo(listenerDTOs, failedListenerDTOs);
        this.sessionAttributeListeners.getRuntimeInfo(listenerDTOs, failedListenerDTOs);
        this.sessionIdListeners.getRuntimeInfo(listenerDTOs, failedListenerDTOs);
        if (listenerDTOs.size() > 0) {
            dto.listenerDTOs = listenerDTOs.toArray(new ListenerDTO[listenerDTOs.size()]);
        }
    }

    public static void contextInitialized(@Nonnull ListenerInfo info, @Nonnull ServletContextListener listener, @Nonnull ServletContextEvent event) {
        try {
            listener.contextInitialized(event);
        }
        catch (Throwable t) {
            SystemLogger.error(info.getServiceReference(), "Exception while calling servlet context listener.", t);
        }
    }

    public static void contextDestroyed(@Nonnull ListenerInfo info, @Nonnull ServletContextListener listener, @Nonnull ServletContextEvent event) {
        try {
            listener.contextDestroyed(event);
        }
        catch (Throwable t) {
            SystemLogger.error(info.getServiceReference(), "Exception while calling servlet context listener.", t);
        }
    }
}

