/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.swap;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ClassInfoTyped;
import org.apache.juneau.commons.reflect.ConstructorInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.swap.ObjectSwap;

public class SurrogateSwap<T, F>
extends ObjectSwap<T, F> {
    private Constructor<F> constructor;
    private Method unswapMethod;

    public static List<SurrogateSwap<?, ?>> findObjectSwaps(Class<?> c, BeanContext bc) {
        LinkedList l = new LinkedList();
        ClassInfoTyped<?> ci = ReflectionUtils.info(c);
        ci.getPublicConstructors().stream().filter(x -> !bc.getAnnotationProvider().has(BeanIgnore.class, (ConstructorInfo)x, new AnnotationTraversal[0]) && x.hasNumParameters(1) && x.isPublic()).forEach(x -> {
            Class pt = x.getParameter(0).getParameterType().inner();
            if (!pt.equals(c.getDeclaringClass())) {
                Method unswapMethod = ci.getPublicMethod(y -> y.hasReturnType(pt)).map(MethodInfo::inner).orElse(null);
                l.add(new SurrogateSwap(pt, x.inner(), unswapMethod));
            }
        });
        return l;
    }

    protected SurrogateSwap(Class<T> forClass, Constructor<F> constructor, Method unswapMethod) {
        super(forClass, constructor.getDeclaringClass());
        this.constructor = constructor;
        this.unswapMethod = unswapMethod;
    }

    @Override
    public F swap(BeanSession session, T o) throws SerializeException {
        try {
            return this.constructor.newInstance(o);
        }
        catch (Exception e) {
            throw new SerializeException(e);
        }
    }

    @Override
    public T unswap(BeanSession session, F f, ClassMeta<?> hint) throws ParseException {
        if (this.unswapMethod == null) {
            throw new ParseException("unswap() method not implement on surrogate class ''{1}'': {0}", Utils.cn(f), this.getNormalClass().getNameFull());
        }
        try {
            return (T)this.unswapMethod.invoke(f, new Object[0]);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }
}

