/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.jetty.resources;

import java.io.FileWriter;
import java.io.Reader;
import java.io.StringReader;
import org.apache.juneau.html.annotation.HtmlDocConfig;
import org.apache.juneau.http.response.Ok;
import org.apache.juneau.microservice.jetty.JettyMicroservice;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestGet;
import org.apache.juneau.rest.annotation.RestPost;
import org.apache.juneau.rest.beans.ResourceDescriptions;
import org.apache.juneau.rest.servlet.BasicRestServlet;

@Rest(path="/debug", title={"Debug"}, description={"Debug Utilities."}, allowedMethodParams="OPTIONS,POST")
@HtmlDocConfig(navlinks={"up: request:/..", "jetty-thread-dump: servlet:/jetty/dump?method=POST", "api: servlet:/api", "stats: servlet:/stats"})
public class DebugResource
extends BasicRestServlet {
    private static final long serialVersionUID = 1L;

    @RestPost(path={"/jetty/dump"}, description={"Generates and saves the jetty thread dump file to jetty-thread-dump.log."})
    public Ok createJettyDump(RestRequest req, RestResponse res) throws Exception {
        String dump = JettyMicroservice.getInstance().getServer().dump();
        try (FileWriter fw = new FileWriter(req.getConfig().get("Logging/logDir").orElse("") + "/jetty-thread-dump.log");){
            fw.write(dump);
        }
        return Ok.OK;
    }

    @RestGet(path={"/"}, description={"Show contents of config file."})
    public ResourceDescriptions getChildren() {
        return ResourceDescriptions.create().append("jetty/dump", "Jetty thread dump");
    }

    @RestGet(path={"/jetty/dump"}, description={"Generates and retrieves the jetty thread dump."})
    public Reader getJettyDump(RestRequest req, RestResponse res) {
        res.setContentType("text/plain");
        return new StringReader(JettyMicroservice.getInstance().getServer().dump());
    }
}

