/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class OAuthFlow
extends OpenApiElement {
    private String authorizationUrl;
    private String tokenUrl;
    private String refreshUrl;
    private Map<String, String> scopes = CollectionUtils.map();

    public OAuthFlow() {
    }

    public OAuthFlow(OAuthFlow copyFrom) {
        super(copyFrom);
        this.authorizationUrl = copyFrom.authorizationUrl;
        this.tokenUrl = copyFrom.tokenUrl;
        this.refreshUrl = copyFrom.refreshUrl;
        if (Utils.nn(copyFrom.scopes)) {
            this.scopes.putAll(copyFrom.scopes);
        }
    }

    public OAuthFlow addScope(String name, String description) {
        AssertionUtils.assertArgNotNull((String)"name", (Object)name);
        AssertionUtils.assertArgNotNull((String)"description", (Object)description);
        this.scopes.put(name, description);
        return this;
    }

    public OAuthFlow copy() {
        return new OAuthFlow(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return (T)(switch (property) {
            case "refreshUrl" -> ConverterUtils.toType((Object)this.getRefreshUrl(), type);
            case "tokenUrl" -> ConverterUtils.toType((Object)this.getTokenUrl(), type);
            case "authorizationUrl" -> ConverterUtils.toType((Object)this.getAuthorizationUrl(), type);
            case "scopes" -> ConverterUtils.toType(this.getScopes(), type);
            default -> super.get(property, type);
        });
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public String getRefreshUrl() {
        return this.refreshUrl;
    }

    public Map<String, String> getScopes() {
        return Utils.nullIfEmpty(this.scopes);
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setb(String.class).addIf(Utils.nn((Object)this.authorizationUrl), (Object)"authorizationUrl").addIf(Utils.nn((Object)this.refreshUrl), (Object)"refreshUrl").addIf(Utils.ne(this.scopes), (Object)"scopes").addIf(Utils.nn((Object)this.tokenUrl), (Object)"tokenUrl").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }

    @Override
    public OAuthFlow set(String property, Object value) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return switch (property) {
            case "authorizationUrl" -> this.setAuthorizationUrl(Utils.s((Object)value));
            case "refreshUrl" -> this.setRefreshUrl(Utils.s((Object)value));
            case "scopes" -> this.setScopes(ConverterUtils.toMapBuilder((Object)value, String.class, String.class).sparse().build());
            case "tokenUrl" -> this.setTokenUrl(Utils.s((Object)value));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public OAuthFlow setAuthorizationUrl(String value) {
        this.authorizationUrl = value;
        return this;
    }

    public OAuthFlow setRefreshUrl(String value) {
        this.refreshUrl = value;
        return this;
    }

    public OAuthFlow setScopes(Map<String, String> value) {
        this.scopes.clear();
        if (Utils.nn(value)) {
            this.scopes.putAll(value);
        }
        return this;
    }

    public OAuthFlow setTokenUrl(String value) {
        this.tokenUrl = value;
        return this;
    }

    @Override
    public OAuthFlow strict() {
        super.strict();
        return this;
    }

    @Override
    public OAuthFlow strict(Object value) {
        super.strict(value);
        return this;
    }
}

