/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.annotation;

import org.apache.juneau.commons.annotation.AnnotationObject;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.http.annotation.License;

public class LicenseAnnotation {
    public static final License DEFAULT = LicenseAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static boolean empty(License a) {
        return a == null || DEFAULT.equals(a);
    }

    public static class Builder
    extends AnnotationObject.Builder {
        private String[] description = new String[0];
        private String name = "";
        private String url = "";

        protected Builder() {
            super(License.class);
        }

        public License build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder url(String value) {
            this.url = value;
            return this;
        }
    }

    private static class Object
    extends AnnotationObject
    implements License {
        private final String[] description;
        private final String name;
        private final String url;

        Object(Builder b) {
            super((AnnotationObject.Builder)b);
            this.description = (String[])CollectionUtils.copyOf((java.lang.Object[])b.description);
            this.name = b.name;
            this.url = b.url;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String url() {
            return this.url;
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }
}

