/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.io.PrintStream;
import java.lang.reflect.Array;
import org.apache.juneau.BasicAssertionError;
import org.apache.juneau.commons.reflect.ExecutableException;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.cp.Messages;

public class Assertion {
    private static final Messages MESSAGES = Messages.of(Assertion.class, "Messages");
    static final String MSG_parameterCannotBeNull = MESSAGES.getString("parameterCannotBeNull");
    static final String MSG_causedBy = MESSAGES.getString("causedBy");
    private String msg;
    private Object[] msgArgs;
    private PrintStream out = System.err;
    private Class<? extends RuntimeException> throwable;

    protected static <E> Class<E[]> arrayClass(Class<E> c) {
        return Array.newInstance(c, 0).getClass();
    }

    protected Assertion(Assertion creator) {
        if (Utils.nn(creator)) {
            this.msg = creator.msg;
            this.msgArgs = creator.msgArgs;
            this.out = creator.out;
            this.throwable = creator.throwable;
        }
    }

    public Assertion setMsg(String msg, Object ... args) {
        this.msg = msg.replace("{msg}", "<<<MSG>>>");
        this.msgArgs = args;
        return this;
    }

    public Assertion setOut(PrintStream value) {
        this.out = value;
        return this;
    }

    public Assertion setSilent() {
        return this.setOut(null);
    }

    public Assertion setStdOut() {
        return this.setOut(System.out);
    }

    public Assertion setThrowable(Class<? extends RuntimeException> value) {
        this.throwable = value;
        return this;
    }

    protected BasicAssertionError error(String msg, Object ... args) {
        return this.error(null, msg, args);
    }

    protected BasicAssertionError error(Throwable cause, String msg, Object ... args) {
        msg = Utils.f(msg, args);
        if (Utils.nn(this.msg)) {
            msg = Utils.f(this.msg, this.msgArgs).replace("<<<MSG>>>", msg);
        }
        if (Utils.nn(this.out)) {
            this.out.println(msg);
        }
        if (Utils.nn(this.throwable)) {
            try {
                throw BeanStore.create().build().addBean(Throwable.class, cause).addBean(String.class, msg).addBean(Object[].class, new Object[0]).createBean(this.throwable).run();
            }
            catch (ExecutableException e) {
                throw ThrowableUtils.rex(cause, msg, new Object[0]);
            }
        }
        return new BasicAssertionError(cause, msg, new Object[0]);
    }
}

