/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.BeanRecursionException;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Delegate;
import org.apache.juneau.MediaType;
import org.apache.juneau.UriContext;
import org.apache.juneau.commons.lang.Flag;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.serializer.WriterSerializerSession;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.swap.ObjectSwap;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlBeanMeta;
import org.apache.juneau.xml.XmlBeanPropertyMeta;
import org.apache.juneau.xml.XmlClassMeta;
import org.apache.juneau.xml.XmlSerializer;
import org.apache.juneau.xml.XmlWriter;
import org.apache.juneau.xml.annotation.XmlFormat;

public class XmlSerializerSession
extends WriterSerializerSession {
    private final String textNodeDelimiter;
    private final XmlSerializer ctx;
    private Namespace defaultNamespace;
    private List<Namespace> namespaces = new ArrayList<Namespace>();

    public static Builder create(XmlSerializer ctx) {
        return new Builder((XmlSerializer)AssertionUtils.assertArgNotNull((String)"ctx", (Object)ctx));
    }

    protected XmlSerializerSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
        this.defaultNamespace = this.findDefaultNamespace(this.ctx.getDefaultNamespace());
        List<Namespace> ctxNamespaces = this.ctx.getNamespaces();
        this.namespaces = ctxNamespaces == null ? new ArrayList<Namespace>() : new ArrayList<Namespace>(ctxNamespaces);
        this.textNodeDelimiter = this.ctx.getTextNodeDelimiter();
    }

    public XmlBeanMeta getXmlBeanMeta(BeanMeta<?> bm) {
        return this.ctx.getXmlBeanMeta(bm);
    }

    public XmlBeanPropertyMeta getXmlBeanPropertyMeta(BeanPropertyMeta bpm) {
        return bpm == null ? XmlBeanPropertyMeta.DEFAULT : this.ctx.getXmlBeanPropertyMeta(bpm);
    }

    public XmlClassMeta getXmlClassMeta(ClassMeta<?> cm) {
        return this.ctx.getXmlClassMeta(cm);
    }

    public final XmlWriter getXmlWriter(SerializerPipe out) throws IOException {
        Object output = out.getRawOutput();
        if (output instanceof XmlWriter) {
            XmlWriter output2 = (XmlWriter)output;
            return output2;
        }
        XmlWriter w = new XmlWriter(out.getWriter(), this.isUseWhitespace(), this.getMaxIndent(), this.isTrimStrings(), this.getQuoteChar(), this.getUriResolver(), this.isEnableNamespaces(), this.defaultNamespace);
        out.setWriter(w);
        return w;
    }

    private void addNamespace(Namespace ns) {
        if (ns == this.defaultNamespace) {
            return;
        }
        for (Namespace n : this.namespaces) {
            if (n != ns) continue;
            return;
        }
        if (Utils.nn((Object)this.defaultNamespace) && (ns.uri.equals(this.defaultNamespace.uri) || ns.name.equals(this.defaultNamespace.name))) {
            this.defaultNamespace = ns;
        } else {
            this.namespaces = CollectionUtils.addAll(this.namespaces, (Object[])new Namespace[]{ns});
        }
    }

    private Namespace findDefaultNamespace(Namespace n) {
        if (n == null) {
            return null;
        }
        if (Utils.nn((Object)n.name) && Utils.nn((Object)n.uri)) {
            return n;
        }
        if (n.uri == null) {
            for (Namespace n2 : this.getNamespaces()) {
                if (!n2.name.equals(n.name)) continue;
                return n2;
            }
        }
        if (n.name == null) {
            for (Namespace n2 : this.getNamespaces()) {
                if (!n2.uri.equals(n.uri)) continue;
                return n2;
            }
        }
        return n;
    }

    private static boolean isTextNode(Object o) {
        if (o == null) {
            return false;
        }
        Class<?> c = o.getClass();
        return CharSequence.class.isAssignableFrom(c) || Number.class.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c) || c.isPrimitive();
    }

    private boolean isXmlText(XmlFormat format, ClassMeta<?> sType) {
        if (format == XmlFormat.XMLTEXT) {
            return true;
        }
        XmlClassMeta xcm = this.getXmlClassMeta(sType);
        if (xcm == null) {
            return false;
        }
        return xcm.getFormat() == XmlFormat.XMLTEXT;
    }

    private ContentResult serializeBeanMap(XmlWriter out, BeanMap<?> m, Namespace elementNs, boolean isCollapsed, boolean isMixedOrText) throws SerializeException {
        boolean hasChildren = false;
        BeanMeta<?> bm = m.getMeta();
        ArrayList lp = new ArrayList();
        Predicate<Object> checkNull = x -> this.isKeepNullProperties() || Utils.nn((Object)x);
        m.forEachValue(checkNull, (pMeta, key, value, thrown) -> lp.add(new BeanPropertyValue((BeanPropertyMeta)pMeta, (String)key, value, (Throwable)thrown)));
        XmlBeanMeta xbm = this.getXmlBeanMeta(bm);
        Set<String> attrs = xbm.getAttrPropertyNames();
        Set<String> elements = xbm.getElementPropertyNames();
        Set<String> collapsedElements = xbm.getCollapsedPropertyNames();
        String attrsProperty = xbm.getAttrsPropertyName();
        String contentProperty = xbm.getContentPropertyName();
        XmlFormat cf = null;
        Object content = null;
        ClassMeta<?> contentType = null;
        for (BeanPropertyValue p : lp) {
            Namespace ns;
            Object pMeta2;
            String n = p.getName();
            if (!attrs.contains(n) && !attrs.contains("*") && !n.equals(attrsProperty) || !((BeanPropertyMeta)(pMeta2 = p.getMeta())).canRead()) continue;
            ClassMeta<?> cMeta = p.getClassMeta();
            String key2 = p.getName();
            Object value2 = p.getValue();
            Throwable t = p.getThrown();
            if (Utils.nn((Object)t)) {
                this.onBeanGetterException((BeanPropertyMeta)pMeta2, t);
            }
            if (this.canIgnoreValue(cMeta, key2, value2)) continue;
            XmlBeanPropertyMeta bpXml = this.getXmlBeanPropertyMeta((BeanPropertyMeta)pMeta2);
            Namespace namespace = ns = this.isEnableNamespaces() && bpXml.getNamespace() != elementNs ? bpXml.getNamespace() : null;
            if (((BeanPropertyMeta)pMeta2).isUri()) {
                out.attrUri(ns, key2, value2);
                continue;
            }
            if (n.equals(attrsProperty)) {
                if (value2 instanceof BeanMap) {
                    BeanMap bm2 = (BeanMap)value2;
                    bm2.forEachValue(x -> true, (arg_0, arg_1, arg_2, arg_3) -> this.lambda$serializeBeanMap$3((BeanPropertyMeta)pMeta2, out, ns, arg_0, arg_1, arg_2, arg_3));
                    continue;
                }
                Map m2 = (Map)value2;
                if (!Utils.nn((Object)m2)) continue;
                m2.forEach((k, v) -> out.attr(ns, Utils.s((Object)k), v));
                continue;
            }
            out.attr(ns, key2, value2);
        }
        boolean hasContent = false;
        boolean preserveWhitespace = false;
        boolean isVoidElement = xbm.getContentFormat() == XmlFormat.VOID;
        for (BeanPropertyValue p : lp) {
            BeanPropertyMeta pMeta3 = p.getMeta();
            if (!pMeta3.canRead()) continue;
            ClassMeta<?> cMeta = p.getClassMeta();
            String n = p.getName();
            if (n.equals(contentProperty)) {
                content = p.getValue();
                contentType = p.getClassMeta();
                hasContent = true;
                cf = xbm.getContentFormat();
                if (cf.isOneOf(XmlFormat.MIXED, XmlFormat.MIXED_PWS, XmlFormat.TEXT, XmlFormat.TEXT_PWS, XmlFormat.XMLTEXT)) {
                    isMixedOrText = true;
                }
                if (cf.isOneOf(XmlFormat.MIXED_PWS, XmlFormat.TEXT_PWS)) {
                    preserveWhitespace = true;
                }
                if (contentType.isCollection() && ((Collection)content).isEmpty()) {
                    hasContent = false;
                    continue;
                }
                if (!contentType.isArray() || Array.getLength(content) != 0) continue;
                hasContent = false;
                continue;
            }
            if (!elements.contains(n) && !collapsedElements.contains(n) && !elements.contains("*") && !collapsedElements.contains("*")) continue;
            String key3 = p.getName();
            Object value3 = p.getValue();
            Throwable t = p.getThrown();
            if (Utils.nn((Object)t)) {
                this.onBeanGetterException(pMeta3, t);
            }
            if (this.canIgnoreValue(cMeta, key3, value3)) continue;
            if (!hasChildren) {
                hasChildren = true;
                out.appendIf(!isCollapsed, '>').nlIf(!isMixedOrText, this.indent);
            }
            XmlBeanPropertyMeta bpXml = this.getXmlBeanPropertyMeta(pMeta3);
            this.serializeAnything(out, value3, cMeta, key3, null, bpXml.getNamespace(), false, bpXml.getXmlFormat(), isMixedOrText, false, pMeta3);
        }
        if (contentProperty == null && !hasContent) {
            return hasChildren ? ContentResult.CR_ELEMENTS : (isVoidElement ? ContentResult.CR_VOID : ContentResult.CR_EMPTY);
        }
        if (Utils.nn(content)) {
            out.w('>').nlIf(!isMixedOrText, this.indent);
            if (contentType != null) {
                if (contentType.isCollection()) {
                    c = (List<Object>)content;
                    boolean previousWasTextNode = false;
                    for (Object value2 : c) {
                        boolean currentIsTextNode = XmlSerializerSession.isTextNode(value2);
                        if (previousWasTextNode && currentIsTextNode && Utils.nn((Object)this.textNodeDelimiter) && !this.textNodeDelimiter.isEmpty()) {
                            out.append(this.textNodeDelimiter);
                        }
                        this.serializeAnything(out, value2, contentType.getElementType(), null, null, null, false, cf, isMixedOrText, preserveWhitespace, null);
                        previousWasTextNode = currentIsTextNode;
                    }
                } else if (contentType.isArray()) {
                    c = XmlSerializerSession.toList(Object[].class, content);
                    boolean previousWasTextNode = false;
                    for (Object value2 : c) {
                        boolean currentIsTextNode = XmlSerializerSession.isTextNode(value2);
                        if (previousWasTextNode && currentIsTextNode && Utils.nn((Object)this.textNodeDelimiter) && !this.textNodeDelimiter.isEmpty()) {
                            out.append(this.textNodeDelimiter);
                        }
                        this.serializeAnything(out, value2, contentType.getElementType(), null, null, null, false, cf, isMixedOrText, preserveWhitespace, null);
                        previousWasTextNode = currentIsTextNode;
                    }
                } else {
                    this.serializeAnything(out, content, contentType, null, null, null, false, cf, isMixedOrText, preserveWhitespace, null);
                }
            }
        } else {
            if (this.isAddJsonTags()) {
                out.attr("nil", "true");
            }
            out.w('>').nlIf(!isMixedOrText, this.indent);
        }
        return isMixedOrText ? ContentResult.CR_MIXED : ContentResult.CR_ELEMENTS;
    }

    private XmlWriter serializeCollection(XmlWriter out, Object in, ClassMeta<?> sType, ClassMeta<?> eType, BeanPropertyMeta ppMeta, boolean isMixed) throws SerializeException {
        ClassMeta<?> eeType = eType.getElementType();
        List<Object> c = sType.isCollection() ? (List<Object>)in : XmlSerializerSession.toList(sType.inner(), in);
        String type2 = null;
        Value eName = Value.of((Object)type2);
        Value eNs = Value.empty();
        if (Utils.nn((Object)ppMeta)) {
            XmlBeanPropertyMeta bpXml = this.getXmlBeanPropertyMeta(ppMeta);
            eName.set((Object)bpXml.getChildName());
            eNs.set((Object)bpXml.getNamespace());
        }
        Value previousWasTextNode = Value.of((Object)false);
        this.forEachEntry(c, (E x) -> {
            boolean currentIsTextNode = XmlSerializerSession.isTextNode(x);
            if (((Boolean)previousWasTextNode.get()).booleanValue() && currentIsTextNode && Utils.nn((Object)this.textNodeDelimiter) && !this.textNodeDelimiter.isEmpty()) {
                out.append(this.textNodeDelimiter);
            }
            this.serializeAnything(out, x, eeType, null, (String)eName.get(), (Namespace)eNs.get(), false, XmlFormat.DEFAULT, isMixed, false, null);
            previousWasTextNode.set((Object)currentIsTextNode);
        });
        return out;
    }

    private ContentResult serializeMap(XmlWriter out, Map m, ClassMeta<?> sType, ClassMeta<?> eKeyType, ClassMeta<?> eValueType, boolean isMixed) throws SerializeException {
        ClassMeta<?> keyType = eKeyType == null ? sType.getKeyType() : eKeyType;
        ClassMeta<?> valueType = eValueType == null ? sType.getValueType() : eValueType;
        Flag hasChildren = Flag.create();
        this.forEachEntry(m, (Map.Entry<K, V> e) -> {
            Object k = e.getKey();
            if (k == null) {
                k = "\u0000";
            } else {
                k = this.generalize(k, keyType);
                if (this.isTrimStrings() && k instanceof String) {
                    k = k.toString().trim();
                }
            }
            Object value = e.getValue();
            hasChildren.ifNotSet(() -> out.w('>').nlIf(!isMixed, this.indent)).set();
            this.serializeAnything(out, value, valueType, this.toString(k), null, null, false, XmlFormat.DEFAULT, isMixed, false, null);
        });
        return hasChildren.isSet() ? ContentResult.CR_ELEMENTS : ContentResult.CR_EMPTY;
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws IOException, SerializeException {
        if (this.isEnableNamespaces() && this.isAutoDetectNamespaces()) {
            this.findNsfMappings(o);
        }
        this.serializeAnything(this.getXmlWriter(out), o, this.getExpectedRootType(o), null, null, null, this.isEnableNamespaces() && this.isAddNamespaceUrisToRoot(), XmlFormat.DEFAULT, false, false, null);
    }

    protected final void findNsfMappings(Object o) throws SerializeException {
        block15: {
            BeanMap<Object> bm;
            block17: {
                ClassMeta<?> aType;
                block19: {
                    Object[] innerType;
                    block21: {
                        block20: {
                            block18: {
                                block16: {
                                    Namespace ns;
                                    aType = null;
                                    try {
                                        aType = this.push(null, o, null);
                                    }
                                    catch (BeanRecursionException e) {
                                        throw new SerializeException(e);
                                    }
                                    if (Utils.nn(aType) && Utils.nn((Object)(ns = this.getXmlClassMeta(aType).getNamespace()))) {
                                        if (Utils.nn((Object)ns.uri)) {
                                            this.addNamespace(ns);
                                        } else {
                                            ns = null;
                                        }
                                    }
                                    if (!Utils.nn(aType) || aType.isPrimitive()) break block15;
                                    bm = null;
                                    if (!aType.isBeanMap()) break block16;
                                    bm = (BeanMap)o;
                                    break block17;
                                }
                                if (!aType.isBean()) break block18;
                                bm = this.toBeanMap(o);
                                break block17;
                            }
                            if (!aType.isDelegate()) break block19;
                            innerType = ((Delegate)o).getClassMeta();
                            Value ns = Value.of((Object)this.getXmlClassMeta((ClassMeta<?>)innerType).getNamespace());
                            if (ns.isPresent()) {
                                if (Utils.nn((Object)((Namespace)ns.get()).uri)) {
                                    this.addNamespace((Namespace)ns.get());
                                } else {
                                    ns.getAndUnset();
                                }
                            }
                            if (!innerType.isBean()) break block20;
                            innerType.getBeanMeta().getProperties().values().stream().filter(BeanPropertyMeta::canRead).forEach(x -> {
                                ns.set((Object)this.getXmlBeanPropertyMeta((BeanPropertyMeta)x).getNamespace());
                                if (ns.isPresent() && Utils.nn((Object)((Namespace)ns.get()).uri)) {
                                    this.addNamespace((Namespace)ns.get());
                                }
                            });
                            break block17;
                        }
                        if (!innerType.isMap()) break block21;
                        ((Map)o).forEach((k, v) -> this.findNsfMappings(v));
                        break block17;
                    }
                    if (!innerType.isCollection()) break block17;
                    ((Collection)o).forEach(this::findNsfMappings);
                    break block17;
                }
                if (aType.isMap()) {
                    ((Map)o).forEach((k, v) -> this.findNsfMappings(v));
                } else if (aType.isCollection()) {
                    ((Collection)o).forEach(this::findNsfMappings);
                } else if (aType.isArray() && !aType.getElementType().isPrimitive()) {
                    for (Object o2 : (Object[])o) {
                        this.findNsfMappings(o2);
                    }
                }
            }
            if (Utils.nn((Object)bm)) {
                Predicate<Object> checkNull = x -> this.isKeepNullProperties() || Utils.nn((Object)x);
                bm.forEachValue(checkNull, (pMeta, key, value, thrown) -> {
                    Namespace ns = this.getXmlBeanPropertyMeta((BeanPropertyMeta)pMeta).getNamespace();
                    if (Utils.nn((Object)ns) && Utils.nn((Object)ns.uri)) {
                        this.addNamespace(ns);
                    }
                    try {
                        this.findNsfMappings(value);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
            }
        }
        this.pop();
    }

    protected final Namespace getDefaultNamespace() {
        return this.defaultNamespace;
    }

    protected final List<Namespace> getNamespaces() {
        return this.namespaces == null ? CollectionUtils.l((Object[])new Namespace[0]) : this.namespaces;
    }

    @Override
    protected boolean isAddBeanTypes() {
        return this.ctx.isAddBeanTypes();
    }

    protected final boolean isAddJsonTags() {
        return this.ctx.addJsonTags;
    }

    protected final boolean isAddNamespaceUrisToRoot() {
        return this.ctx.isAddNamespaceUrlsToRoot();
    }

    protected final boolean isAutoDetectNamespaces() {
        return this.ctx.isAutoDetectNamespaces();
    }

    protected final boolean isEnableNamespaces() {
        return this.ctx.isEnableNamespaces();
    }

    protected boolean isHtmlMode() {
        return false;
    }

    protected ContentResult serializeAnything(XmlWriter out, Object o, ClassMeta<?> eType, String keyName, String elementName, Namespace elementNamespace, boolean addNamespaceUris, XmlFormat format, boolean isMixedOrText, boolean preserveWhitespace, BeanPropertyMeta pMeta) throws SerializeException {
        boolean isRaw;
        JsonType type = null;
        int i = isMixedOrText ? 0 : this.indent;
        ClassMeta<Object> aType = null;
        ClassMeta<Object> wType = null;
        ClassMeta<Object> sType = this.object();
        aType = this.push2(keyName, o, eType);
        if (eType == null) {
            eType = this.object();
        }
        if (aType == null) {
            o = null;
            aType = this.object();
        }
        if (XmlSerializerSession.isOptional(aType)) {
            o = this.getOptionalValue(o);
            eType = this.getOptionalType(eType);
            aType = this.getClassMetaForObject(o, this.object());
        }
        if (Utils.nn((Object)o)) {
            if (aType.isDelegate()) {
                wType = aType;
                aType = ((Delegate)o).getClassMeta();
                eType = aType;
            }
            sType = aType;
            ObjectSwap<Object, ?> swap = aType.getSwap(this);
            if (Utils.nn(swap)) {
                o = this.swap(swap, o);
                sType = swap.getSwapClassMeta(this);
                if (sType.isObject()) {
                    sType = this.getClassMetaForObject(o);
                }
            }
        } else {
            sType = eType.getSerializedClassMeta(this);
        }
        boolean isExpectedType = true;
        if (o == null || !eType.same(aType)) {
            isExpectedType = eType.isNumber() ? aType.isNumber() : (eType.isMap() ? aType.isMap() : (eType.isCollectionOrArray() ? aType.isCollectionOrArray() : false));
        }
        String resolvedDictionaryName = isExpectedType ? null : aType.getBeanDictionaryName();
        String dictionaryName = aType.getBeanDictionaryName();
        if (dictionaryName == null) {
            dictionaryName = sType.getBeanDictionaryName();
        }
        if (Utils.nn((Object)o) && sType.isChar() && ((Character)o).charValue() == '\u0000') {
            o = null;
        }
        boolean isCollapsed = false;
        boolean bl = isRaw = (sType.isReader() || sType.isInputStream()) && Utils.nn((Object)o);
        if (o == null) {
            type = JsonType.NULL;
        } else if (sType.isCharSequence() || sType.isChar()) {
            type = JsonType.STRING;
        } else if (sType.isNumber()) {
            type = JsonType.NUMBER;
        } else if (sType.isBoolean()) {
            type = JsonType.BOOLEAN;
        } else if (sType.isMapOrBean()) {
            isCollapsed = this.getXmlClassMeta(sType).getFormat() == XmlFormat.COLLAPSED;
            type = JsonType.OBJECT;
        } else if (sType.isCollectionOrArray()) {
            isCollapsed = format == XmlFormat.COLLAPSED && !addNamespaceUris;
            type = JsonType.ARRAY;
        } else {
            type = JsonType.STRING;
        }
        if (format.isOneOf(XmlFormat.MIXED, XmlFormat.MIXED_PWS, XmlFormat.TEXT, XmlFormat.TEXT_PWS, XmlFormat.XMLTEXT) && type.isOneOf(JsonType.NULL, JsonType.STRING, JsonType.NUMBER, JsonType.BOOLEAN)) {
            isCollapsed = true;
        }
        String name = keyName;
        if (elementName == null && Utils.nn((Object)dictionaryName)) {
            elementName = dictionaryName;
            isExpectedType = Utils.nn((Object)o);
        }
        if (elementName == null) {
            elementName = name;
            name = null;
        }
        if (Utils.eq((Object)name, (Object)elementName)) {
            name = null;
        }
        if (this.isEnableNamespaces()) {
            if (elementNamespace == null) {
                elementNamespace = this.getXmlClassMeta(sType).getNamespace();
            }
            if (elementNamespace == null) {
                elementNamespace = this.getXmlClassMeta(aType).getNamespace();
            }
            if (Utils.nn((Object)elementNamespace) && elementNamespace.uri == null) {
                elementNamespace = null;
            }
            if (elementNamespace == null) {
                elementNamespace = this.defaultNamespace;
            }
        } else {
            elementNamespace = null;
        }
        boolean cr = Utils.nn((Object)o) && (sType.isMapOrBean() || sType.isCollectionOrArray()) && !isMixedOrText;
        String en = elementName;
        if (en == null && !isRaw && this.isAddJsonTags()) {
            en = type.toString();
            type = null;
        }
        boolean encodeEn = Utils.nn((Object)elementName);
        String ns = elementNamespace == null ? null : elementNamespace.name;
        String dns = null;
        String elementNs = null;
        if (this.isEnableNamespaces()) {
            dns = elementName == null && Utils.nn((Object)this.defaultNamespace) ? this.defaultNamespace.name : null;
            String string = elementNs = elementName == null ? dns : ns;
            if (elementName == null) {
                elementNamespace = null;
            }
        }
        if (!isCollapsed) {
            if (Utils.nn((Object)en)) {
                out.oTag(i, elementNs, en, encodeEn);
                if (addNamespaceUris) {
                    out.attr((String)null, "xmlns", (Object)this.defaultNamespace.getUri());
                    for (Namespace n : this.namespaces) {
                        out.attr("xmlns", n.getName(), (Object)n.getUri());
                    }
                }
                if (!isExpectedType) {
                    if (Utils.nn((Object)resolvedDictionaryName)) {
                        out.attr(dns, this.getBeanTypePropertyName(eType), (Object)resolvedDictionaryName);
                    } else if (Utils.nn((Object)((Object)type)) && type != JsonType.STRING) {
                        out.attr(dns, this.getBeanTypePropertyName(eType), (Object)type);
                    }
                }
                if (Utils.nn((Object)name)) {
                    out.attr(XmlSerializerSession.getNamePropertyName(), name);
                }
            } else {
                out.i(i);
            }
            if (o == null && (sType.isBoolean() || sType.isNumber()) && !sType.isNullable()) {
                o = sType.getPrimitiveDefault();
            }
            if (Utils.nn((Object)o) && !sType.isMapOrBean() && en != null) {
                out.w('>');
            }
            if (cr && !sType.isMapOrBean()) {
                out.nl(i + 1);
            }
        }
        ContentResult rc = ContentResult.CR_ELEMENTS;
        if (Utils.nn((Object)o)) {
            if (sType.isUri() || Utils.nn((Object)pMeta) && pMeta.isUri()) {
                out.textUri(o);
            } else if (sType.isCharSequence() || sType.isChar()) {
                if (this.isXmlText(format, sType)) {
                    out.append(o);
                } else {
                    out.text(o, preserveWhitespace);
                }
            } else if (sType.isNumber() || sType.isBoolean()) {
                out.append(o);
            } else if (sType.isMap() || Utils.nn(wType) && wType.isMap()) {
                rc = o instanceof BeanMap ? this.serializeBeanMap(out, (BeanMap)o, elementNamespace, isCollapsed, isMixedOrText) : this.serializeMap(out, (Map)o, sType, eType.getKeyType(), eType.getValueType(), isMixedOrText);
            } else if (sType.isBean()) {
                rc = this.serializeBeanMap(out, this.toBeanMap(o), elementNamespace, isCollapsed, isMixedOrText);
            } else if (sType.isCollection() || Utils.nn(wType) && wType.isCollection()) {
                if (isCollapsed) {
                    --this.indent;
                }
                this.serializeCollection(out, o, sType, eType, pMeta, isMixedOrText);
                if (isCollapsed) {
                    ++this.indent;
                }
            } else if (sType.isArray()) {
                if (isCollapsed) {
                    --this.indent;
                }
                this.serializeCollection(out, o, sType, eType, pMeta, isMixedOrText);
                if (isCollapsed) {
                    ++this.indent;
                }
            } else if (sType.isReader()) {
                IoUtils.pipe((Reader)((Reader)o), (Writer)out, x$0 -> SerializerSession.handleThrown(x$0));
            } else if (sType.isInputStream()) {
                IoUtils.pipe((InputStream)((InputStream)o), (Writer)out, x$0 -> SerializerSession.handleThrown(x$0));
            } else if (this.isXmlText(format, sType)) {
                out.append(this.toString(o));
            } else {
                out.text(this.toString(o));
            }
        }
        this.pop();
        if (!isCollapsed) {
            if (Utils.nn((Object)en)) {
                if (rc == ContentResult.CR_EMPTY) {
                    if (this.isHtmlMode()) {
                        out.w('>').eTag(elementNs, en, encodeEn);
                    } else {
                        out.w('/').w('>');
                    }
                } else if (rc == ContentResult.CR_VOID || o == null) {
                    out.w('/').w('>');
                } else {
                    out.ie(cr && rc != ContentResult.CR_MIXED ? i : 0).eTag(elementNs, en, encodeEn);
                }
            }
            if (!isMixedOrText) {
                out.nl(i);
            }
        }
        return rc;
    }

    private /* synthetic */ void lambda$serializeBeanMap$3(BeanPropertyMeta pMeta, XmlWriter out, Namespace ns, BeanPropertyMeta pMeta2, String key2, Object value2, Throwable thrown2) {
        if (Utils.nn((Object)thrown2)) {
            this.onBeanGetterException(pMeta, thrown2);
        }
        out.attr(ns, key2, value2);
    }

    public static class Builder
    extends WriterSerializerSession.Builder {
        private XmlSerializer ctx;

        protected Builder(XmlSerializer ctx) {
            super((WriterSerializer)AssertionUtils.assertArgNotNull((String)"ctx", (Object)ctx));
            this.ctx = ctx;
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public XmlSerializerSession build() {
            return new XmlSerializerSession(this);
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder javaMethod(Method value) {
            super.javaMethod(value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder resolver(VarResolverSession value) {
            super.resolver(value);
            return this;
        }

        @Override
        public Builder schema(HttpPartSchema value) {
            super.schema(value);
            return this;
        }

        @Override
        public Builder schemaDefault(HttpPartSchema value) {
            super.schemaDefault(value);
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }

        @Override
        public Builder uriContext(UriContext value) {
            super.uriContext(value);
            return this;
        }

        @Override
        public Builder useWhitespace(Boolean value) {
            super.useWhitespace(value);
            return this;
        }
    }

    public static enum ContentResult {
        CR_VOID,
        CR_EMPTY,
        CR_MIXED,
        CR_ELEMENTS;

    }

    static enum JsonType {
        STRING("string"),
        BOOLEAN("boolean"),
        NUMBER("number"),
        ARRAY("array"),
        OBJECT("object"),
        NULL("null");

        private final String value;

        private JsonType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        boolean isOneOf(JsonType ... types) {
            for (JsonType type : types) {
                if (type != this) continue;
                return true;
            }
            return false;
        }
    }
}

