/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.tree;

import com.github.weisj.darklaf.components.tree.LabeledTreeNode;
import com.github.weisj.darklaf.components.tristate.TristateState;
import com.github.weisj.darklaf.util.DarkUIUtil;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class TristateTreeNode
extends DefaultMutableTreeNode
implements LabeledTreeNode {
    private String label;

    public TristateTreeNode() {
        this(null);
    }

    public TristateTreeNode(String label) {
        this(label, TristateState.DESELECTED);
    }

    public TristateTreeNode(String label, TristateState state) {
        this(label, state, true);
    }

    public TristateTreeNode(String label, TristateState state, boolean allowsChildren) {
        this.parent = null;
        this.allowsChildren = allowsChildren;
        this.userObject = state;
        this.label = label;
    }

    @Override
    public void add(MutableTreeNode newChild) {
        if (!(newChild instanceof TristateTreeNode)) {
            throw new IllegalArgumentException("Only children of type TristateTreeNode are allowed.");
        }
        super.add(newChild);
    }

    public TristateState getState() {
        return this.getUserObject();
    }

    public void setState(TristateState state) {
        this.setState(state, false, false);
    }

    private void setState(TristateState s, boolean invokedByParent, boolean invokedByChild) {
        TristateTreeNode treeNode;
        if (this.isLeaf() && ((TristateState)((Object)this.userObject)).isIndeterminate()) {
            throw new IllegalArgumentException("Leaf nodes cannot have an indeterminate state");
        }
        TristateState state = s.isIndeterminate() && !this.getState().isIndeterminate() ? this.getState().next().next() : s;
        super.setUserObject((Object)state);
        if (!(this.isLeaf() || invokedByChild || state.isIndeterminate())) {
            for (Object node : this.children) {
                if (!(node instanceof TristateTreeNode)) continue;
                ((TristateTreeNode)node).setState(state, true, false);
            }
        }
        if (!invokedByParent && (treeNode = DarkUIUtil.nullableCast(TristateTreeNode.class, this.getParent())) != null) {
            treeNode.setState(treeNode.getEffectiveState(), false, true);
        }
    }

    public void setSelected(boolean selected) {
        this.userObject = selected;
    }

    public TristateState getUserObject() {
        return DarkUIUtil.nullableCast(TristateState.class, super.getUserObject());
    }

    @Override
    public void setUserObject(Object userObject) {
        if (!(userObject instanceof TristateState)) {
            throw new IllegalArgumentException("Only values of type TristateState are allowed but got " + userObject);
        }
        this.setState((TristateState)((Object)userObject));
    }

    public TristateState getEffectiveState() {
        TristateState state = null;
        for (Object node : this.children) {
            if (!(node instanceof TristateTreeNode)) continue;
            TristateState nodeState = ((TristateTreeNode)node).getUserObject();
            if (state == null) {
                state = nodeState;
            }
            if (state == nodeState) continue;
            state = TristateState.INDETERMINATE_SEL;
            break;
        }
        return state != null ? state : TristateState.DESELECTED;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }
}

