/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.optimizer.reorder;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.engine.optimizer.reorder.PatternElements;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemList;

public final class PatternTriple {
    public Item subject;
    public Item predicate;
    public Item object;

    public static PatternTriple parse(Item pt) {
        ItemList list = pt.getList();
        return new PatternTriple(list.get(0), list.get(1), list.get(2));
    }

    public PatternTriple(Item s, Item p, Item o) {
        this.set(PatternTriple.normalize(s), PatternTriple.normalize(p), PatternTriple.normalize(o));
    }

    private void set(Item s, Item p, Item o) {
        this.subject = s;
        this.predicate = p;
        this.object = o;
    }

    public PatternTriple(Node s, Node p, Node o) {
        this.set(PatternTriple.normalize(s), PatternTriple.normalize(p), PatternTriple.normalize(o));
    }

    public PatternTriple(Triple triple) {
        this(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public String toString() {
        return String.valueOf(this.subject) + " " + String.valueOf(this.predicate) + " " + String.valueOf(this.object);
    }

    private static Item normalize(Item x) {
        return x != null ? x : PatternElements.ANY;
    }

    private static Item normalize(Node x) {
        return x != null ? Item.createNode(x) : PatternElements.ANY;
    }
}

