/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.bean.factorypostprocessor;

import java.util.Map;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.container.spring.lifecycle.ConfigurationProvider;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class ConfigurationBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private Map<String, String> beans;

    public void setBeans(Map<String, String> beans) {
        this.beans = beans;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        ConfigurationProvider confProvider = (ConfigurationProvider)beanFactory.getBean(ConfigurationProvider.class);
        for (String name : this.beans.keySet()) {
            try {
                HierarchicalConfiguration<ImmutableNode> config = confProvider.getConfiguration(name);
                String repClass = config.getString("[@class]");
                BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
                AbstractBeanDefinition def = BeanDefinitionBuilder.genericBeanDefinition((String)repClass).getBeanDefinition();
                registry.registerBeanDefinition(name, (BeanDefinition)def);
                String aliases = this.beans.get(name);
                String[] aliasArray = aliases.split(",");
                if (aliasArray == null) continue;
                for (String anAliasArray : aliasArray) {
                    String alias = anAliasArray.trim();
                    if (alias.length() <= 0) continue;
                    registry.registerAlias(name, anAliasArray);
                }
            }
            catch (ConfigurationException e) {
                throw new FatalBeanException("Unable to parse configuration for bean " + name, (Throwable)e);
            }
        }
    }
}

