/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.fastfail;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.james.smtpserver.fastfail.URIScanner;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URIRBLHandler
implements JamesMessageHook,
ProtocolHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(URIRBLHandler.class);
    private static final ProtocolSession.AttachmentKey<String> LISTED_DOMAIN = ProtocolSession.AttachmentKey.of((String)"LISTED_DOMAIN", String.class);
    private static final ProtocolSession.AttachmentKey<String> URBLSERVER = ProtocolSession.AttachmentKey.of((String)"URBL_SERVER", String.class);
    private DNSService dnsService;
    private Collection<String> uriRbl;
    private boolean getDetail = false;

    public final DNSService getDNSService() {
        return this.dnsService;
    }

    @Inject
    public final void setDNSService(DNSService dnsService) {
        this.dnsService = dnsService;
    }

    public void setUriRblServer(Collection<String> uriRbl) {
        this.uriRbl = uriRbl;
    }

    public void setGetDetail(boolean getDetail) {
        this.getDetail = getDetail;
    }

    @Override
    public HookResult onMessage(SMTPSession session, Mail mail) {
        if (this.check(session, mail)) {
            Collection txt;
            Optional uRblServer = session.getAttachment(URBLSERVER, ProtocolSession.State.Transaction);
            Optional target = session.getAttachment(LISTED_DOMAIN, ProtocolSession.State.Transaction);
            String detail = null;
            if (uRblServer.isPresent() && target.isPresent() && this.getDetail && !(txt = this.dnsService.findTXTRecords((String)target.get() + "." + (String)uRblServer.get())).isEmpty()) {
                detail = (String)txt.iterator().next();
            }
            if (detail != null) {
                return HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpDescription(DSNStatus.getStatus((int)5, (String)"7.0") + "Rejected: message contains domain " + (String)target.get() + " listed by " + uRblServer + " . Details: " + detail).build();
            }
            return HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpDescription(DSNStatus.getStatus((int)5, (String)"7.0") + " Rejected: message contains domain " + target.orElse("[target not set]") + " listed by " + uRblServer).build();
        }
        return HookResult.DECLINED;
    }

    private HashSet<String> scanMailForDomains(MimePart part, SMTPSession session) throws MessagingException, IOException {
        HashSet<String> domains = new HashSet<String>();
        LOGGER.debug("mime type is: \"{}\"", (Object)part.getContentType());
        if (part.isMimeType("text/plain") || part.isMimeType("text/html")) {
            LOGGER.debug("scanning: \"{}\"", part.getContent());
            HashSet<String> newDom = URIScanner.scanContentForDomains(domains, part.getContent().toString());
            if (newDom != null && newDom.size() > 0) {
                domains.addAll(newDom);
            }
        } else if (part.isMimeType("multipart/*")) {
            MimeMultipart multipart = (MimeMultipart)part.getContent();
            int count = multipart.getCount();
            LOGGER.debug("multipart count is: {}", (Object)count);
            for (int index = 0; index < count; ++index) {
                LOGGER.debug("recursing index: {}", (Object)index);
                MimeBodyPart mimeBodyPart = (MimeBodyPart)multipart.getBodyPart(index);
                HashSet<String> newDomains = this.scanMailForDomains((MimePart)mimeBodyPart, session);
                if (newDomains == null || newDomains.size() <= 0) continue;
                domains.addAll(newDomains);
            }
        }
        return domains;
    }

    protected boolean check(SMTPSession session, Mail mail) {
        try {
            MimeMessage message = mail.getMessage();
            HashSet<String> domains = this.scanMailForDomains((MimePart)message, session);
            for (String domain : domains) {
                Iterator<String> uRbl = this.uriRbl.iterator();
                String target = domain;
                while (uRbl.hasNext()) {
                    try {
                        String uRblServer = uRbl.next();
                        String address = target + "." + uRblServer;
                        LOGGER.debug("Lookup {}", (Object)address);
                        this.dnsService.getByName(address);
                        session.setAttachment(URBLSERVER, (Object)uRblServer, ProtocolSession.State.Transaction);
                        session.setAttachment(LISTED_DOMAIN, (Object)target, ProtocolSession.State.Transaction);
                        return true;
                    }
                    catch (UnknownHostException unknownHostException) {
                    }
                }
            }
        }
        catch (IOException | MessagingException e) {
            LOGGER.error(e.getMessage());
        }
        return false;
    }

    public void init(Configuration config) throws ConfigurationException {
        String[] servers = config.getStringArray("uriRblServers.server");
        ArrayList<String> serverCollection = new ArrayList<String>();
        for (String rblServerName : servers) {
            serverCollection.add(rblServerName);
            LOGGER.info("Adding uriRBL server: {}", (Object)rblServerName);
        }
        if (serverCollection == null || serverCollection.size() <= 0) {
            throw new ConfigurationException("Please provide at least one server");
        }
        this.setUriRblServer(serverCollection);
        this.setGetDetail(config.getBoolean("getDetail", false));
    }
}

