/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.mail.MessagingException;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.server.core.MailImpl;
import org.apache.james.util.MemoizedSupplier;
import org.apache.mailet.DsnParameters;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.apache.mailet.ProcessingState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipientRewriteTableProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecipientRewriteTableProcessor.class);
    private final RecipientRewriteTable virtualTableStore;
    private final MailetContext mailetContext;
    private final Supplier<Domain> defaultDomainSupplier;
    private final ProcessingState errorProcessor;

    public RecipientRewriteTableProcessor(RecipientRewriteTable virtualTableStore, DomainList domainList, MailetContext mailetContext, ProcessingState errorProcessor) {
        this.virtualTableStore = virtualTableStore;
        this.mailetContext = mailetContext;
        this.defaultDomainSupplier = MemoizedSupplier.of((Supplier)Throwing.supplier(() -> this.getDefaultDomain(domainList)).sneakyThrow());
        this.errorProcessor = errorProcessor;
    }

    public RecipientRewriteTableProcessor(RecipientRewriteTable virtualTableStore, DomainList domainList, MailetContext mailetContext) {
        this(virtualTableStore, domainList, mailetContext, new ProcessingState("error"));
    }

    private Domain getDefaultDomain(DomainList domainList) throws MessagingException {
        try {
            return domainList.getDefaultDomain();
        }
        catch (DomainListException e) {
            throw new MessagingException("Unable to access DomainList", (Exception)((Object)e));
        }
    }

    public void processMail(Mail mail) throws MessagingException {
        List<Decision> decisions = this.executeRrtFor(mail);
        this.applyDecisionsOnMailRecipients(mail, decisions);
        this.applyDecisionOnDSNParameters(mail, decisions);
    }

    private void applyDecisionOnDSNParameters(Mail mail, List<Decision> decisions) {
        mail.dsnParameters().map(dsnParameters -> decisions.stream().reduce(dsnParameters, (parameters, decision) -> decision.applyOnDsnParameters((DsnParameters)parameters), (a, b) -> {
            throw new NotImplementedException("No combiner needed as we are not in a multi-threaded environment");
        })).ifPresent(arg_0 -> ((Mail)mail).setDsnParameters(arg_0));
    }

    private void applyDecisionsOnMailRecipients(Mail mail, List<Decision> decisions) throws MessagingException {
        RrtExecutionResult executionResults = decisions.stream().map(Decision::executionResult).reduce(RrtExecutionResult.empty(), (x$0, x$1) -> RrtExecutionResult.merge(x$0, x$1));
        if (!executionResults.recipientWithError.isEmpty()) {
            MailImpl newMail = MailImpl.builder().name(mail.getName()).sender(mail.getMaybeSender()).addRecipients(executionResults.recipientWithError).mimeMessage(mail.getMessage()).state(this.errorProcessor.getValue()).build();
            this.mailetContext.sendMail((Mail)newMail);
            LifecycleUtil.dispose((Object)newMail);
        }
        if (executionResults.newRecipients.isEmpty()) {
            mail.setState("ghost");
        }
        mail.setRecipients(executionResults.newRecipients);
    }

    private List<Decision> executeRrtFor(Mail mail) {
        Function<MailAddress, Decision> convertToMappingData = recipient -> {
            Preconditions.checkNotNull((Object)recipient);
            return this.executeRrtForRecipient(mail, (MailAddress)recipient);
        };
        return (List)mail.getRecipients().stream().map(convertToMappingData).collect(ImmutableList.toImmutableList());
    }

    private Decision executeRrtForRecipient(Mail mail, MailAddress recipient) {
        try {
            Mappings mappings = this.virtualTableStore.getResolvedMappings(recipient.getLocalPart(), recipient.getDomain());
            if (mappings != null && !mappings.isEmpty()) {
                List<MailAddress> newMailAddresses = this.handleMappings(mappings, mail, recipient);
                return new Decision(recipient, RrtExecutionResult.success(newMailAddresses));
            }
            return new Decision(recipient, RrtExecutionResult.success(recipient));
        }
        catch (RecipientRewriteTable.ErrorMappingException | RecipientRewriteTableException e) {
            LOGGER.warn("Could not rewrite recipient {}", (Object)recipient, (Object)e);
            return new Decision(recipient, RrtExecutionResult.error(recipient));
        }
    }

    @VisibleForTesting
    List<MailAddress> handleMappings(Mappings mappings, Mail mail, MailAddress recipient) {
        boolean isLocal = true;
        ImmutableMap<Boolean, List<MailAddress>> mailAddressSplit = this.splitRemoteMailAddresses(mappings);
        this.forwardToRemoteAddress(mail, recipient, (Collection)mailAddressSplit.get(!isLocal));
        return (List)mailAddressSplit.get(isLocal);
    }

    private ImmutableMap<Boolean, List<MailAddress>> splitRemoteMailAddresses(Mappings mappings) {
        return (ImmutableMap)this.mailAddressesPerDomain(mappings).collect(Collectors.partitioningBy(entry -> this.mailetContext.isLocalServer((Domain)entry.getKey()))).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (List)((List)entry.getValue()).stream().flatMap(domainEntry -> ((Collection)domainEntry.getValue()).stream()).collect(ImmutableList.toImmutableList())));
    }

    private Stream<Map.Entry<Domain, Collection<MailAddress>>> mailAddressesPerDomain(Mappings mappings) {
        return ((ImmutableListMultimap)mappings.asStream().map(mapping -> mapping.appendDomainIfNone(this.defaultDomainSupplier)).map(Mapping::asMailAddress).flatMap(Optional::stream).collect(ImmutableListMultimap.toImmutableListMultimap(MailAddress::getDomain, Function.identity()))).asMap().entrySet().stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardToRemoteAddress(Mail mail, MailAddress recipient, Collection<MailAddress> remoteRecipients) {
        if (!remoteRecipients.isEmpty()) {
            Mail duplicate = null;
            try {
                duplicate = mail.duplicate();
                duplicate.setRecipients((Collection)ImmutableList.copyOf(remoteRecipients));
                this.mailetContext.sendMail(duplicate);
                LOGGER.info("Mail for {} forwarded to {}", (Object)recipient, remoteRecipients);
            }
            catch (MessagingException ex) {
                LOGGER.warn("Error forwarding mail to {}", remoteRecipients);
            }
            finally {
                LifecycleUtil.dispose((Object)duplicate);
            }
        }
    }

    private static class RrtExecutionResult {
        private final ImmutableSet<MailAddress> newRecipients;
        private final ImmutableSet<MailAddress> recipientWithError;

        private static RrtExecutionResult empty() {
            return new RrtExecutionResult((ImmutableSet<MailAddress>)ImmutableSet.of(), (ImmutableSet<MailAddress>)ImmutableSet.of());
        }

        private static RrtExecutionResult error(MailAddress mailAddress) {
            return new RrtExecutionResult((ImmutableSet<MailAddress>)ImmutableSet.of(), (ImmutableSet<MailAddress>)ImmutableSet.of((Object)mailAddress));
        }

        private static RrtExecutionResult success(MailAddress mailAddress) {
            return new RrtExecutionResult((ImmutableSet<MailAddress>)ImmutableSet.of((Object)mailAddress), (ImmutableSet<MailAddress>)ImmutableSet.of());
        }

        private static RrtExecutionResult success(List<MailAddress> mailAddresses) {
            return new RrtExecutionResult((ImmutableSet<MailAddress>)ImmutableSet.copyOf(mailAddresses), (ImmutableSet<MailAddress>)ImmutableSet.of());
        }

        private static RrtExecutionResult merge(RrtExecutionResult result1, RrtExecutionResult result2) {
            return new RrtExecutionResult((ImmutableSet<MailAddress>)ImmutableSet.builder().addAll(result1.getNewRecipients()).addAll(result2.getNewRecipients()).build(), (ImmutableSet<MailAddress>)ImmutableSet.builder().addAll(result1.getRecipientWithError()).addAll(result2.getRecipientWithError()).build());
        }

        public RrtExecutionResult(ImmutableSet<MailAddress> newRecipients, ImmutableSet<MailAddress> recipientWithError) {
            this.newRecipients = newRecipients;
            this.recipientWithError = recipientWithError;
        }

        public Set<MailAddress> getNewRecipients() {
            return this.newRecipients;
        }

        public Set<MailAddress> getRecipientWithError() {
            return this.recipientWithError;
        }
    }

    private static class Decision {
        private final MailAddress originalAddress;
        private final RrtExecutionResult executionResult;

        private Decision(MailAddress originalAddress, RrtExecutionResult executionResult) {
            this.originalAddress = originalAddress;
            this.executionResult = executionResult;
        }

        MailAddress originalAddress() {
            return this.originalAddress;
        }

        RrtExecutionResult executionResult() {
            return this.executionResult;
        }

        DsnParameters applyOnDsnParameters(DsnParameters dsnParameters) {
            ImmutableMap rcptParameters = dsnParameters.getRcptParameters();
            Optional<DsnParameters.RecipientDsnParameters> originalRcptParameter = Optional.ofNullable((DsnParameters.RecipientDsnParameters)rcptParameters.get((Object)this.originalAddress));
            return originalRcptParameter.map(parameters -> {
                Map newRcptParameters = (Map)this.executionResult.getNewRecipients().stream().map(newRcpt -> Pair.of((Object)newRcpt, (Object)parameters)).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
                Map rcptParametersWithoutOriginal = (Map)rcptParameters.entrySet().stream().filter(rcpt -> !((MailAddress)rcpt.getKey()).equals((Object)this.originalAddress)).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
                return dsnParameters.withRcptParameters((Map)ImmutableMap.builder().putAll(rcptParametersWithoutOriginal).putAll(newRcptParameters).build());
            }).orElse(dsnParameters);
        }
    }
}

