/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.app.spring;

import com.github.fge.lambdas.Throwing;
import java.lang.management.ManagementFactory;
import java.util.Calendar;
import java.util.function.Consumer;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.apache.commons.daemon.Daemon;
import org.apache.commons.daemon.DaemonContext;
import org.apache.james.container.spring.context.JamesServerApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JamesAppSpringMain
implements Daemon {
    private static final ObjectName ALL_OBJECT_NAME = null;
    private static final QueryExp ALL_QUERY_EXP = null;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JamesAppSpringMain.class.getName());
    private JamesServerApplicationContext context;

    public static void main(String[] args) throws Exception {
        JamesAppSpringMain.unregisterLog4JMBeans();
        if (System.getProperty("com.sun.management.jmxremote.password.file") == null) {
            LOGGER.warn("No authentication setted up for the JMX component. This expose you to local privilege escalation attacks risk. This can be done via the 'com.sun.management.jmxremote.password.file' system property.");
        }
        long start = Calendar.getInstance().getTimeInMillis();
        JamesAppSpringMain main = new JamesAppSpringMain();
        main.init(null);
        long end = Calendar.getInstance().getTimeInMillis();
        LOGGER.info("Apache James Server is successfully started in {} milliseconds.", (Object)(end - start));
    }

    private static void unregisterLog4JMBeans() {
        if (System.getProperty("james.jmx.unregister.log4j.mbeans", "true").equals("true")) {
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            platformMBeanServer.queryMBeans(ALL_OBJECT_NAME, ALL_QUERY_EXP).stream().filter(objectInstance -> objectInstance.getClassName().startsWith("org.apache.logging.log4j")).forEach((Consumer<ObjectInstance>)Throwing.consumer(objectInstance -> platformMBeanServer.unregisterMBean(objectInstance.getObjectName())));
        }
    }

    public void destroy() {
    }

    public void init(DaemonContext arg0) throws Exception {
        this.context = new JamesServerApplicationContext(new String[]{"META-INF/org/apache/james/spring-server.xml"});
        this.context.registerShutdownHook();
        this.context.start();
    }

    public void start() throws Exception {
        this.context.start();
    }

    public void stop() throws Exception {
        if (this.context != null) {
            this.context.stop();
        }
    }
}

