/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.RequestAware;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.mailbox.store.transaction.Mapper;
import org.apache.james.mailbox.store.user.SubscriptionMapper;
import org.apache.james.mailbox.store.user.SubscriptionMapperFactory;
import org.apache.james.mailbox.store.user.model.Subscription;
import org.reactivestreams.Publisher;

public class StoreSubscriptionManager
implements SubscriptionManager {
    private static final int INITIAL_SIZE = 32;
    protected SubscriptionMapperFactory mapperFactory;

    @Inject
    public StoreSubscriptionManager(SubscriptionMapperFactory mapperFactory) {
        this.mapperFactory = mapperFactory;
    }

    public void subscribe(MailboxSession session, String mailbox) throws SubscriptionException {
        SubscriptionMapper mapper = this.mapperFactory.getSubscriptionMapper(session);
        try {
            mapper.execute(Mapper.toTransaction(() -> {
                Subscription newSubscription = new Subscription(session.getUser(), mailbox);
                mapper.save(newSubscription);
            }));
        }
        catch (MailboxException e) {
            throw new SubscriptionException((Exception)((Object)e));
        }
    }

    public Collection<String> subscriptions(MailboxSession session) throws SubscriptionException {
        return this.mapperFactory.getSubscriptionMapper(session).findSubscriptionsForUser(session.getUser()).stream().map(Subscription::getMailbox).collect(Collectors.toCollection(() -> new HashSet(32)));
    }

    public Publisher<String> subscriptionsReactive(MailboxSession session) throws SubscriptionException {
        return this.mapperFactory.getSubscriptionMapper(session).findSubscriptionsForUserReactive(session.getUser()).map(Subscription::getMailbox);
    }

    public void unsubscribe(MailboxSession session, String mailbox) throws SubscriptionException {
        SubscriptionMapper mapper = this.mapperFactory.getSubscriptionMapper(session);
        try {
            mapper.execute(Mapper.toTransaction(() -> mapper.delete(new Subscription(session.getUser(), mailbox))));
        }
        catch (MailboxException e) {
            throw new SubscriptionException((Exception)((Object)e));
        }
    }

    public void endProcessingRequest(MailboxSession session) {
        if (this.mapperFactory instanceof RequestAware) {
            ((RequestAware)this.mapperFactory).endProcessingRequest(session);
        }
    }

    public void startProcessingRequest(MailboxSession session) {
    }
}

