/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import javax.inject.Inject;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.quota.DefaultUserQuotaRootResolver;
import org.apache.james.mailbox.store.quota.NoMaxQuotaManager;
import org.apache.james.mailbox.store.quota.NoQuotaManager;

public class QuotaComponents {
    private final MaxQuotaManager maxQuotaManager;
    private final QuotaManager quotaManager;
    private final QuotaRootResolver quotaRootResolver;

    public static QuotaComponents disabled(SessionProvider sessionProvider, MailboxSessionMapperFactory mailboxSessionMapperFactory) {
        return new QuotaComponents(new NoMaxQuotaManager(), new NoQuotaManager(), (QuotaRootResolver)new DefaultUserQuotaRootResolver(sessionProvider, mailboxSessionMapperFactory));
    }

    @Inject
    public QuotaComponents(MaxQuotaManager maxQuotaManager, QuotaManager quotaManager, QuotaRootResolver quotaRootResolver) {
        this.maxQuotaManager = maxQuotaManager;
        this.quotaManager = quotaManager;
        this.quotaRootResolver = quotaRootResolver;
    }

    public MaxQuotaManager getMaxQuotaManager() {
        return this.maxQuotaManager;
    }

    public QuotaManager getQuotaManager() {
        return this.quotaManager;
    }

    public QuotaRootResolver getQuotaRootResolver() {
        return this.quotaRootResolver;
    }
}

