/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.send;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.james.jmap.draft.send.MailMetadata;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class MailSpool
implements Startable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailSpool.class);
    private final MailQueueFactory<?> queueFactory;
    private MailQueue queue;

    @Inject
    @VisibleForTesting
    MailSpool(MailQueueFactory<?> queueFactory) {
        this.queueFactory = queueFactory;
    }

    public void start() {
        this.queue = this.queueFactory.createQueue(MailQueueFactory.SPOOL);
    }

    @PreDestroy
    public void dispose() {
        try {
            this.queue.close();
        }
        catch (IOException e) {
            LOGGER.debug("error closing queue", (Throwable)e);
        }
    }

    public Mono<Void> send(Mail mail, MailMetadata metadata) {
        mail.setAttribute(new Attribute(MailMetadata.MAIL_METADATA_MESSAGE_ID_ATTRIBUTE, AttributeValue.of((String)metadata.getMessageId().serialize())));
        mail.setAttribute(new Attribute(MailMetadata.MAIL_METADATA_USERNAME_ATTRIBUTE, AttributeValue.of((String)metadata.getUsername())));
        return Mono.from((Publisher)this.queue.enqueueReactive(mail));
    }
}

