/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.Version;

public class JMAPRoutesHandler {
    private final Version version;
    private final Set<JMAPRoutes> routes;

    public JMAPRoutesHandler(Version version, JMAPRoutes ... routes) {
        this.version = version;
        this.routes = ImmutableSet.copyOf((Object[])routes);
    }

    public JMAPRoutesHandler(Version version, Set<JMAPRoutes> routes) {
        this.version = version;
        this.routes = routes;
    }

    Stream<JMAPRoute> routes(Version versionRequest) {
        if (this.version.equals(versionRequest)) {
            return this.routes.stream().flatMap(JMAPRoutes::routes);
        }
        return Stream.of(new JMAPRoute[0]);
    }
}

