/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search.elasticsearch.v7;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.backends.es.v7.IndexName;
import org.apache.james.backends.es.v7.ReadAliasName;
import org.apache.james.backends.es.v7.WriteAliasName;
import org.apache.james.quota.search.elasticsearch.v7.QuotaRatioElasticSearchConstants;

public class ElasticSearchQuotaConfiguration {
    public static final String ELASTICSEARCH_INDEX_QUOTA_RATIO_NAME = "elasticsearch.index.quota.ratio.name";
    public static final String ELASTICSEARCH_ALIAS_READ_QUOTA_RATIO_NAME = "elasticsearch.alias.read.quota.ratio.name";
    public static final String ELASTICSEARCH_ALIAS_WRITE_QUOTA_RATIO_NAME = "elasticsearch.alias.write.quota.ratio.name";
    public static final ElasticSearchQuotaConfiguration DEFAULT_CONFIGURATION = ElasticSearchQuotaConfiguration.builder().build();
    private final IndexName indexQuotaRatioName;
    private final ReadAliasName readAliasQuotaRatioName;
    private final WriteAliasName writeAliasQuotaRatioName;

    public static Builder builder() {
        return new Builder();
    }

    public static ElasticSearchQuotaConfiguration fromProperties(Configuration configuration) {
        return ElasticSearchQuotaConfiguration.builder().indexQuotaRatioName(ElasticSearchQuotaConfiguration.computeQuotaSearchIndexName(configuration)).readAliasQuotaRatioName(ElasticSearchQuotaConfiguration.computeQuotaSearchReadAlias(configuration)).writeAliasQuotaRatioName(ElasticSearchQuotaConfiguration.computeQuotaSearchWriteAlias(configuration)).build();
    }

    public static Optional<IndexName> computeQuotaSearchIndexName(Configuration configuration) {
        return Optional.ofNullable(configuration.getString(ELASTICSEARCH_INDEX_QUOTA_RATIO_NAME)).map(IndexName::new);
    }

    public static Optional<WriteAliasName> computeQuotaSearchWriteAlias(Configuration configuration) {
        return Optional.ofNullable(configuration.getString(ELASTICSEARCH_ALIAS_WRITE_QUOTA_RATIO_NAME)).map(WriteAliasName::new);
    }

    public static Optional<ReadAliasName> computeQuotaSearchReadAlias(Configuration configuration) {
        return Optional.ofNullable(configuration.getString(ELASTICSEARCH_ALIAS_READ_QUOTA_RATIO_NAME)).map(ReadAliasName::new);
    }

    private ElasticSearchQuotaConfiguration(IndexName indexQuotaRatioName, ReadAliasName readAliasQuotaRatioName, WriteAliasName writeAliasQuotaRatioName) {
        this.indexQuotaRatioName = indexQuotaRatioName;
        this.readAliasQuotaRatioName = readAliasQuotaRatioName;
        this.writeAliasQuotaRatioName = writeAliasQuotaRatioName;
    }

    public IndexName getIndexQuotaRatioName() {
        return this.indexQuotaRatioName;
    }

    public ReadAliasName getReadAliasQuotaRatioName() {
        return this.readAliasQuotaRatioName;
    }

    public WriteAliasName getWriteAliasQuotaRatioName() {
        return this.writeAliasQuotaRatioName;
    }

    public final boolean equals(Object o) {
        if (o instanceof ElasticSearchQuotaConfiguration) {
            ElasticSearchQuotaConfiguration that = (ElasticSearchQuotaConfiguration)o;
            return Objects.equals(this.indexQuotaRatioName, that.indexQuotaRatioName) && Objects.equals(this.readAliasQuotaRatioName, that.readAliasQuotaRatioName) && Objects.equals(this.writeAliasQuotaRatioName, that.writeAliasQuotaRatioName);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.indexQuotaRatioName, this.readAliasQuotaRatioName);
    }

    public static class Builder {
        private Optional<IndexName> indexQuotaRatioName = Optional.empty();
        private Optional<ReadAliasName> readAliasQuotaRatioName = Optional.empty();
        private Optional<WriteAliasName> writeAliasQuotaRatioName = Optional.empty();

        public Builder indexQuotaRatioName(IndexName indexQuotaRatioName) {
            return this.indexQuotaRatioName(Optional.of(indexQuotaRatioName));
        }

        public Builder indexQuotaRatioName(Optional<IndexName> indexQuotaRatioName) {
            this.indexQuotaRatioName = indexQuotaRatioName;
            return this;
        }

        public Builder readAliasQuotaRatioName(ReadAliasName readAliasQuotaRatioName) {
            return this.readAliasQuotaRatioName(Optional.of(readAliasQuotaRatioName));
        }

        public Builder readAliasQuotaRatioName(Optional<ReadAliasName> readAliasQuotaRatioName) {
            this.readAliasQuotaRatioName = readAliasQuotaRatioName;
            return this;
        }

        public Builder writeAliasQuotaRatioName(WriteAliasName writeAliasQuotaRatioName) {
            return this.writeAliasQuotaRatioName(Optional.of(writeAliasQuotaRatioName));
        }

        public Builder writeAliasQuotaRatioName(Optional<WriteAliasName> writeAliasQuotaRatioName) {
            this.writeAliasQuotaRatioName = writeAliasQuotaRatioName;
            return this;
        }

        public ElasticSearchQuotaConfiguration build() {
            return new ElasticSearchQuotaConfiguration(this.indexQuotaRatioName.orElse(QuotaRatioElasticSearchConstants.DEFAULT_QUOTA_RATIO_INDEX), this.readAliasQuotaRatioName.orElse(QuotaRatioElasticSearchConstants.DEFAULT_QUOTA_RATIO_READ_ALIAS), this.writeAliasQuotaRatioName.orElse(QuotaRatioElasticSearchConstants.DEFAULT_QUOTA_RATIO_WRITE_ALIAS));
        }
    }
}

