/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lmtp;

import java.util.ArrayList;
import java.util.List;
import org.apache.james.protocols.api.Response;

public class LMTPMultiResponse
implements Response {
    private final List<Response> responses = new ArrayList<Response>();

    public static LMTPMultiResponse of(List<Response> responses) {
        return new LMTPMultiResponse(responses);
    }

    private LMTPMultiResponse(List<Response> responses) {
        this.responses.addAll(responses);
    }

    public LMTPMultiResponse(Response response) {
        this.addResponse(response);
    }

    public void addResponse(Response response) {
        this.responses.add(response);
    }

    public String getRetCode() {
        return this.responses.get(0).getRetCode();
    }

    public List<CharSequence> getLines() {
        ArrayList<CharSequence> lines = new ArrayList<CharSequence>();
        for (Response response : this.responses) {
            lines.addAll(response.getLines());
        }
        return lines;
    }

    public boolean isEndSession() {
        for (Response response : this.responses) {
            if (!response.isEndSession()) continue;
            return true;
        }
        return false;
    }
}

