/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.utils;

import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import reactor.core.publisher.Mono;

public class CassandraHealthCheck
implements HealthCheck {
    private static final ComponentName COMPONENT_NAME = new ComponentName("Cassandra backend");
    private static final String SAMPLE_QUERY = "SELECT NOW() FROM system.local";
    private final CassandraAsyncExecutor queryExecutor;

    @Inject
    public CassandraHealthCheck(Session session) {
        this.queryExecutor = new CassandraAsyncExecutor(session);
    }

    public ComponentName componentName() {
        return COMPONENT_NAME;
    }

    public Mono<Result> check() {
        return this.queryExecutor.execute((Statement)new SimpleStatement(SAMPLE_QUERY)).map(resultSet -> Result.healthy((ComponentName)COMPONENT_NAME)).onErrorResume(e -> Mono.just((Object)Result.unhealthy((ComponentName)COMPONENT_NAME, (String)"Error checking Cassandra backend", (Throwable)e)));
    }
}

