/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.util.ValuePatch;
import org.apache.james.vacation.api.AccountId;
import org.apache.james.vacation.api.Vacation;
import org.apache.james.vacation.api.VacationPatch;
import org.apache.james.vacation.api.VacationService;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.VacationDTO;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonExtractException;
import org.apache.james.webadmin.utils.JsonExtractor;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.Responses;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;

public class VacationRoutes
implements Routes {
    public static final String VACATION = "/vacation";
    private static final String USER_NAME = ":userName";
    private final JsonTransformer jsonTransformer;
    private final JsonExtractor<VacationDTO> jsonExtractor;
    private final VacationService vacationService;
    private final UsersRepository usersRepository;

    @Inject
    public VacationRoutes(VacationService vacationService, UsersRepository usersRepository, JsonTransformer jsonTransformer) {
        this.vacationService = vacationService;
        this.usersRepository = usersRepository;
        this.jsonTransformer = jsonTransformer;
        this.jsonExtractor = new JsonExtractor(VacationDTO.class, new Module[]{new JavaTimeModule()});
    }

    public String getBasePath() {
        return VACATION;
    }

    public void define(Service service) {
        service.get("/vacation/:userName", this::getVacation, (ResponseTransformer)this.jsonTransformer);
        service.post("/vacation/:userName", this::updateVacation);
        service.delete("/vacation/:userName", this::deleteVacation);
    }

    public VacationDTO getVacation(Request request, Response response) {
        this.testUserExists(request);
        AccountId accountId = AccountId.fromString((String)request.params(USER_NAME));
        Vacation vacation = (Vacation)this.vacationService.retrieveVacation(accountId).block();
        return VacationDTO.from(vacation);
    }

    public String updateVacation(Request request, Response response) throws JsonExtractException {
        this.testUserExists(request);
        AccountId accountId = AccountId.fromString((String)request.params(USER_NAME));
        VacationDTO vacationDto = (VacationDTO)this.jsonExtractor.parse(request.body());
        VacationPatch vacationPatch = VacationPatch.builder().subject(VacationRoutes.updateOrKeep(vacationDto.getSubject())).textBody(VacationRoutes.updateOrKeep(vacationDto.getTextBody())).htmlBody(VacationRoutes.updateOrKeep(vacationDto.getHtmlBody())).fromDate(VacationRoutes.updateOrKeep(vacationDto.getFromDate())).toDate(VacationRoutes.updateOrKeep(vacationDto.getToDate())).isEnabled(VacationRoutes.updateOrKeep(vacationDto.getEnabled())).build();
        this.vacationService.modifyVacation(accountId, vacationPatch).block();
        return Responses.returnNoContent((Response)response);
    }

    public String deleteVacation(Request request, Response response) {
        this.testUserExists(request);
        AccountId accountId = AccountId.fromString((String)request.params(USER_NAME));
        VacationPatch vacationPatch = VacationPatch.builder().isEnabled(Boolean.valueOf(false)).subject(ValuePatch.remove()).textBody(ValuePatch.remove()).htmlBody(ValuePatch.remove()).fromDate(ValuePatch.remove()).toDate(ValuePatch.remove()).build();
        this.vacationService.modifyVacation(accountId, vacationPatch).block();
        return Responses.returnNoContent((Response)response);
    }

    private void testUserExists(Request request) {
        Username username = Username.of((String)request.params(USER_NAME));
        if (!this.isExistingUser(username)) {
            throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message("The user '" + username.asString() + "' does not exist").haltError();
        }
    }

    private boolean isExistingUser(Username username) {
        try {
            return this.usersRepository.contains(username);
        }
        catch (UsersRepositoryException e) {
            return false;
        }
    }

    private static <T> ValuePatch<T> updateOrKeep(Optional<T> opt) {
        return opt.map(ValuePatch::modifyTo).orElse(ValuePatch.keep());
    }
}

