/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Update;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.backends.cassandra.init.configuration.CassandraConsistenciesConfiguration;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageMetadata;
import org.apache.james.mailbox.cassandra.mail.FlagsExtractor;
import org.apache.james.mailbox.cassandra.table.CassandraMessageIds;
import org.apache.james.mailbox.cassandra.table.CassandraMessageV3Table;
import org.apache.james.mailbox.cassandra.table.MessageIdToImapUid;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.mailbox.model.UpdatedFlags;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraMessageIdToImapUidDAO {
    private static final String MOD_SEQ_CONDITION = "modSeqCondition";
    private static final String ADDED_USERS_FLAGS = "added_user_flags";
    private static final String REMOVED_USERS_FLAGS = "removed_user_flags";
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final BlobId.Factory blobIdFactory;
    private final PreparedStatement delete;
    private final PreparedStatement insert;
    private final PreparedStatement insertForced;
    private final PreparedStatement update;
    private final PreparedStatement selectAll;
    private final PreparedStatement select;
    private final PreparedStatement listStatement;
    private final CassandraConfiguration cassandraConfiguration;
    private final CassandraConsistenciesConfiguration consistenciesConfiguration;

    @Inject
    public CassandraMessageIdToImapUidDAO(Session session, BlobId.Factory blobIdFactory, CassandraConsistenciesConfiguration consistenciesConfiguration, CassandraConfiguration cassandraConfiguration) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.blobIdFactory = blobIdFactory;
        this.consistenciesConfiguration = consistenciesConfiguration;
        this.cassandraConfiguration = cassandraConfiguration;
        this.delete = this.prepareDelete(session);
        this.insert = this.prepareInsert(session);
        this.insertForced = this.prepareInsertForced(session);
        this.update = this.prepareUpdate(session);
        this.selectAll = this.prepareSelectAll(session);
        this.select = this.prepareSelect(session);
        this.listStatement = this.prepareList(session);
    }

    private PreparedStatement prepareDelete(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("imapUidTable").where(QueryBuilder.eq((String)"messageId", (Object)QueryBuilder.bindMarker((String)"messageId"))).and(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
    }

    private PreparedStatement prepareInsert(Session session) {
        Insert insert = QueryBuilder.insertInto((String)"imapUidTable").value("messageId", (Object)QueryBuilder.bindMarker((String)"messageId")).value("mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId")).value("uid", (Object)QueryBuilder.bindMarker((String)"uid")).value("threadId", (Object)QueryBuilder.bindMarker((String)"threadId")).value("modSeq", (Object)QueryBuilder.bindMarker((String)"modSeq")).value("flagAnswered", (Object)QueryBuilder.bindMarker((String)"flagAnswered")).value("flagDeleted", (Object)QueryBuilder.bindMarker((String)"flagDeleted")).value("flagDraft", (Object)QueryBuilder.bindMarker((String)"flagDraft")).value("flagFlagged", (Object)QueryBuilder.bindMarker((String)"flagFlagged")).value("flagRecent", (Object)QueryBuilder.bindMarker((String)"flagRecent")).value("flagSeen", (Object)QueryBuilder.bindMarker((String)"flagSeen")).value("flagUser", (Object)QueryBuilder.bindMarker((String)"flagUser")).value("userFlags", (Object)QueryBuilder.bindMarker((String)"userFlags")).value("internalDate", (Object)QueryBuilder.bindMarker((String)"internalDate")).value("bodyStartOctet", (Object)QueryBuilder.bindMarker((String)"bodyStartOctet")).value("fullContentOctets", (Object)QueryBuilder.bindMarker((String)"fullContentOctets")).value("headerContent", (Object)QueryBuilder.bindMarker((String)"headerContent"));
        if (this.cassandraConfiguration.isMessageWriteStrongConsistency()) {
            return session.prepare((RegularStatement)insert.ifNotExists());
        }
        return session.prepare((RegularStatement)QueryBuilder.update((String)"imapUidTable").with(QueryBuilder.set((String)"threadId", (Object)QueryBuilder.bindMarker((String)"threadId"))).and(QueryBuilder.set((String)"modSeq", (Object)QueryBuilder.bindMarker((String)"modSeq"))).and(QueryBuilder.set((String)"flagAnswered", (Object)QueryBuilder.bindMarker((String)"flagAnswered"))).and(QueryBuilder.set((String)"flagDeleted", (Object)QueryBuilder.bindMarker((String)"flagDeleted"))).and(QueryBuilder.set((String)"flagDraft", (Object)QueryBuilder.bindMarker((String)"flagDraft"))).and(QueryBuilder.set((String)"flagFlagged", (Object)QueryBuilder.bindMarker((String)"flagFlagged"))).and(QueryBuilder.set((String)"flagRecent", (Object)QueryBuilder.bindMarker((String)"flagRecent"))).and(QueryBuilder.set((String)"flagSeen", (Object)QueryBuilder.bindMarker((String)"flagSeen"))).and(QueryBuilder.set((String)"flagUser", (Object)QueryBuilder.bindMarker((String)"flagUser"))).and(QueryBuilder.addAll((String)"userFlags", (BindMarker)QueryBuilder.bindMarker((String)"userFlags"))).and(QueryBuilder.set((String)"internalDate", (Object)QueryBuilder.bindMarker((String)"internalDate"))).and(QueryBuilder.set((String)"bodyStartOctet", (Object)QueryBuilder.bindMarker((String)"bodyStartOctet"))).and(QueryBuilder.set((String)"fullContentOctets", (Object)QueryBuilder.bindMarker((String)"fullContentOctets"))).and(QueryBuilder.set((String)"headerContent", (Object)QueryBuilder.bindMarker((String)"headerContent"))).where(QueryBuilder.eq((String)"messageId", (Object)QueryBuilder.bindMarker((String)"messageId"))).and(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.eq((String)"uid", (Object)QueryBuilder.bindMarker((String)"uid"))));
    }

    private PreparedStatement prepareInsertForced(Session session) {
        Insert insert = QueryBuilder.insertInto((String)"imapUidTable").value("messageId", (Object)QueryBuilder.bindMarker((String)"messageId")).value("mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId")).value("uid", (Object)QueryBuilder.bindMarker((String)"uid")).value("modSeq", (Object)QueryBuilder.bindMarker((String)"modSeq")).value("flagAnswered", (Object)QueryBuilder.bindMarker((String)"flagAnswered")).value("flagDeleted", (Object)QueryBuilder.bindMarker((String)"flagDeleted")).value("flagDraft", (Object)QueryBuilder.bindMarker((String)"flagDraft")).value("flagFlagged", (Object)QueryBuilder.bindMarker((String)"flagFlagged")).value("flagRecent", (Object)QueryBuilder.bindMarker((String)"flagRecent")).value("flagSeen", (Object)QueryBuilder.bindMarker((String)"flagSeen")).value("flagUser", (Object)QueryBuilder.bindMarker((String)"flagUser")).value("userFlags", (Object)QueryBuilder.bindMarker((String)"userFlags")).value("internalDate", (Object)QueryBuilder.bindMarker((String)"internalDate")).value("bodyStartOctet", (Object)QueryBuilder.bindMarker((String)"bodyStartOctet")).value("fullContentOctets", (Object)QueryBuilder.bindMarker((String)"fullContentOctets")).value("headerContent", (Object)QueryBuilder.bindMarker((String)"headerContent"));
        return session.prepare((RegularStatement)insert);
    }

    private PreparedStatement prepareUpdate(Session session) {
        Update.Where update = QueryBuilder.update((String)"imapUidTable").with(QueryBuilder.set((String)"modSeq", (Object)QueryBuilder.bindMarker((String)"modSeq"))).and(QueryBuilder.set((String)"flagAnswered", (Object)QueryBuilder.bindMarker((String)"flagAnswered"))).and(QueryBuilder.set((String)"flagDeleted", (Object)QueryBuilder.bindMarker((String)"flagDeleted"))).and(QueryBuilder.set((String)"flagDraft", (Object)QueryBuilder.bindMarker((String)"flagDraft"))).and(QueryBuilder.set((String)"flagFlagged", (Object)QueryBuilder.bindMarker((String)"flagFlagged"))).and(QueryBuilder.set((String)"flagRecent", (Object)QueryBuilder.bindMarker((String)"flagRecent"))).and(QueryBuilder.set((String)"flagSeen", (Object)QueryBuilder.bindMarker((String)"flagSeen"))).and(QueryBuilder.set((String)"flagUser", (Object)QueryBuilder.bindMarker((String)"flagUser"))).and(QueryBuilder.addAll((String)"userFlags", (BindMarker)QueryBuilder.bindMarker((String)ADDED_USERS_FLAGS))).and(QueryBuilder.removeAll((String)"userFlags", (BindMarker)QueryBuilder.bindMarker((String)REMOVED_USERS_FLAGS))).where(QueryBuilder.eq((String)"messageId", (Object)QueryBuilder.bindMarker((String)"messageId"))).and(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.eq((String)"uid", (Object)QueryBuilder.bindMarker((String)"uid")));
        if (this.cassandraConfiguration.isMessageWriteStrongConsistency()) {
            return session.prepare((RegularStatement)update.onlyIf(QueryBuilder.eq((String)"modSeq", (Object)QueryBuilder.bindMarker((String)MOD_SEQ_CONDITION))));
        }
        return session.prepare((RegularStatement)update);
    }

    private PreparedStatement prepareSelectAll(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("imapUidTable").where(QueryBuilder.eq((String)CassandraMessageIds.MESSAGE_ID_LOWERCASE, (Object)QueryBuilder.bindMarker((String)CassandraMessageIds.MESSAGE_ID_LOWERCASE))));
    }

    private PreparedStatement prepareList(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("imapUidTable"));
    }

    private PreparedStatement prepareSelect(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("imapUidTable").where(QueryBuilder.eq((String)CassandraMessageIds.MESSAGE_ID_LOWERCASE, (Object)QueryBuilder.bindMarker((String)CassandraMessageIds.MESSAGE_ID_LOWERCASE))).and(QueryBuilder.eq((String)CassandraMessageIds.MAILBOX_ID_LOWERCASE, (Object)QueryBuilder.bindMarker((String)CassandraMessageIds.MAILBOX_ID_LOWERCASE))));
    }

    public Mono<Void> delete(CassandraMessageId messageId, CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.delete.bind().setUUID("messageId", messageId.get()).setUUID("mailboxId", mailboxId.asUuid()));
    }

    public Mono<Void> insert(CassandraMessageMetadata metadata) {
        ComposedMessageId composedMessageId = metadata.getComposedMessageId().getComposedMessageId();
        Flags flags = metadata.getComposedMessageId().getFlags();
        ThreadId threadId = metadata.getComposedMessageId().getThreadId();
        BoundStatement boundStatement = this.insert.bind();
        if (metadata.getComposedMessageId().getFlags().getUserFlags().length == 0) {
            boundStatement.unset("userFlags");
        } else {
            boundStatement.setSet("userFlags", (Set)ImmutableSet.copyOf((Object[])flags.getUserFlags()));
        }
        return this.cassandraAsyncExecutor.executeVoid((Statement)boundStatement.setUUID("messageId", ((CassandraMessageId)composedMessageId.getMessageId()).get()).setUUID("mailboxId", ((CassandraId)composedMessageId.getMailboxId()).asUuid()).setLong("uid", composedMessageId.getUid().asLong()).setLong("modSeq", metadata.getComposedMessageId().getModSeq().asLong()).setUUID("threadId", ((CassandraMessageId)threadId.getBaseMessageId()).get()).setBool("flagAnswered", flags.contains(Flags.Flag.ANSWERED)).setBool("flagDeleted", flags.contains(Flags.Flag.DELETED)).setBool("flagDraft", flags.contains(Flags.Flag.DRAFT)).setBool("flagFlagged", flags.contains(Flags.Flag.FLAGGED)).setBool("flagRecent", flags.contains(Flags.Flag.RECENT)).setBool("flagSeen", flags.contains(Flags.Flag.SEEN)).setBool("flagUser", flags.contains(Flags.Flag.USER)).setTimestamp("internalDate", metadata.getInternalDate().get()).setInt("bodyStartOctet", Math.toIntExact(metadata.getBodyStartOctet().get())).setLong("fullContentOctets", metadata.getSize().get().longValue()).setString("headerContent", metadata.getHeaderContent().get().asString()));
    }

    public Mono<Void> insertForce(CassandraMessageMetadata metadata) {
        ComposedMessageId composedMessageId = metadata.getComposedMessageId().getComposedMessageId();
        Flags flags = metadata.getComposedMessageId().getFlags();
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.insertForced.bind().setUUID("messageId", ((CassandraMessageId)composedMessageId.getMessageId()).get()).setUUID("mailboxId", ((CassandraId)composedMessageId.getMailboxId()).asUuid()).setLong("uid", composedMessageId.getUid().asLong()).setLong("modSeq", metadata.getComposedMessageId().getModSeq().asLong()).setBool("flagAnswered", flags.contains(Flags.Flag.ANSWERED)).setBool("flagDeleted", flags.contains(Flags.Flag.DELETED)).setBool("flagDraft", flags.contains(Flags.Flag.DRAFT)).setBool("flagFlagged", flags.contains(Flags.Flag.FLAGGED)).setBool("flagRecent", flags.contains(Flags.Flag.RECENT)).setBool("flagSeen", flags.contains(Flags.Flag.SEEN)).setBool("flagUser", flags.contains(Flags.Flag.USER)).setSet("userFlags", (Set)ImmutableSet.copyOf((Object[])flags.getUserFlags())).setTimestamp("internalDate", metadata.getInternalDate().get()).setInt("bodyStartOctet", Math.toIntExact(metadata.getBodyStartOctet().get())).setLong("fullContentOctets", metadata.getSize().get().longValue()).setString("headerContent", metadata.getHeaderContent().get().asString()));
    }

    public Mono<Boolean> updateMetadata(ComposedMessageId id, UpdatedFlags updatedFlags, ModSeq previousModeq) {
        return this.cassandraAsyncExecutor.executeReturnApplied((Statement)this.updateBoundStatement(id, updatedFlags, previousModeq));
    }

    private BoundStatement updateBoundStatement(ComposedMessageId id, UpdatedFlags updatedFlags, ModSeq previousModeq) {
        BoundStatement boundStatement = this.update.bind().setLong("modSeq", updatedFlags.getModSeq().asLong()).setUUID("messageId", ((CassandraMessageId)id.getMessageId()).get()).setUUID("mailboxId", ((CassandraId)id.getMailboxId()).asUuid()).setLong("uid", id.getUid().asLong());
        if (updatedFlags.isChanged(Flags.Flag.ANSWERED)) {
            boundStatement.setBool("flagAnswered", updatedFlags.isModifiedToSet(Flags.Flag.ANSWERED));
        } else {
            boundStatement.unset("flagAnswered");
        }
        if (updatedFlags.isChanged(Flags.Flag.DRAFT)) {
            boundStatement.setBool("flagDraft", updatedFlags.isModifiedToSet(Flags.Flag.DRAFT));
        } else {
            boundStatement.unset("flagDraft");
        }
        if (updatedFlags.isChanged(Flags.Flag.FLAGGED)) {
            boundStatement.setBool("flagFlagged", updatedFlags.isModifiedToSet(Flags.Flag.FLAGGED));
        } else {
            boundStatement.unset("flagFlagged");
        }
        if (updatedFlags.isChanged(Flags.Flag.DELETED)) {
            boundStatement.setBool("flagDeleted", updatedFlags.isModifiedToSet(Flags.Flag.DELETED));
        } else {
            boundStatement.unset("flagDeleted");
        }
        if (updatedFlags.isChanged(Flags.Flag.RECENT)) {
            boundStatement.setBool("flagRecent", updatedFlags.getNewFlags().contains(Flags.Flag.RECENT));
        } else {
            boundStatement.unset("flagRecent");
        }
        if (updatedFlags.isChanged(Flags.Flag.SEEN)) {
            boundStatement.setBool("flagSeen", updatedFlags.isModifiedToSet(Flags.Flag.SEEN));
        } else {
            boundStatement.unset("flagSeen");
        }
        if (updatedFlags.isChanged(Flags.Flag.USER)) {
            boundStatement.setBool("flagUser", updatedFlags.isModifiedToSet(Flags.Flag.USER));
        } else {
            boundStatement.unset("flagUser");
        }
        Sets.SetView removedFlags = Sets.difference((Set)ImmutableSet.copyOf((Object[])updatedFlags.getOldFlags().getUserFlags()), (Set)ImmutableSet.copyOf((Object[])updatedFlags.getNewFlags().getUserFlags()));
        Sets.SetView addedFlags = Sets.difference((Set)ImmutableSet.copyOf((Object[])updatedFlags.getNewFlags().getUserFlags()), (Set)ImmutableSet.copyOf((Object[])updatedFlags.getOldFlags().getUserFlags()));
        if (addedFlags.isEmpty()) {
            boundStatement.unset(ADDED_USERS_FLAGS);
        } else {
            boundStatement.setSet(ADDED_USERS_FLAGS, (Set)addedFlags);
        }
        if (removedFlags.isEmpty()) {
            boundStatement.unset(REMOVED_USERS_FLAGS);
        } else {
            boundStatement.setSet(REMOVED_USERS_FLAGS, (Set)removedFlags);
        }
        if (this.cassandraConfiguration.isMessageWriteStrongConsistency()) {
            return boundStatement.setLong(MOD_SEQ_CONDITION, previousModeq.asLong());
        }
        return boundStatement;
    }

    public Flux<CassandraMessageMetadata> retrieve(CassandraMessageId messageId, Optional<CassandraId> mailboxId, CassandraConsistenciesConfiguration.ConsistencyChoice readConsistencyChoice) {
        return this.cassandraAsyncExecutor.executeRows(this.selectStatement(messageId, mailboxId).setConsistencyLevel(readConsistencyChoice.choose(this.consistenciesConfiguration))).map(this::toComposedMessageIdWithMetadata);
    }

    @VisibleForTesting
    public Flux<CassandraMessageMetadata> retrieve(CassandraMessageId messageId, Optional<CassandraId> mailboxId) {
        return this.retrieve(messageId, mailboxId, CassandraConsistenciesConfiguration.ConsistencyChoice.STRONG);
    }

    public Flux<CassandraMessageMetadata> retrieveAllMessages() {
        return this.cassandraAsyncExecutor.executeRows(this.listStatement.bind().setReadTimeoutMillis(Duration.ofDays(1L).toMillisPart())).map(this::toComposedMessageIdWithMetadata);
    }

    private CassandraMessageMetadata toComposedMessageIdWithMetadata(Row row) {
        CassandraMessageId messageId = CassandraMessageId.Factory.of(row.getUUID(CassandraMessageIds.MESSAGE_ID_LOWERCASE));
        return CassandraMessageMetadata.builder().ids(ComposedMessageIdWithMetaData.builder().composedMessageId(new ComposedMessageId((MailboxId)CassandraId.of(row.getUUID(CassandraMessageIds.MAILBOX_ID_LOWERCASE)), (MessageId)messageId, MessageUid.of((long)row.getLong("uid")))).flags(FlagsExtractor.getFlags(row)).threadId(this.getThreadIdFromRow(row, messageId)).modSeq(ModSeq.of((long)row.getLong(MessageIdToImapUid.MOD_SEQ_LOWERCASE))).build()).bodyStartOctet(row.getInt(CassandraMessageV3Table.BODY_START_OCTET_LOWERCASE)).internalDate(row.getTimestamp(CassandraMessageV3Table.INTERNAL_DATE_LOWERCASE)).size(row.getLong(CassandraMessageV3Table.FULL_CONTENT_OCTETS_LOWERCASE)).headerContent(Optional.ofNullable(row.getString(CassandraMessageV3Table.HEADER_CONTENT_LOWERCASE)).map(arg_0 -> ((BlobId.Factory)this.blobIdFactory).from(arg_0))).build();
    }

    private ThreadId getThreadIdFromRow(Row row, MessageId messageId) {
        UUID threadIdUUID = row.getUUID(MessageIdToImapUid.THREAD_ID_LOWERCASE);
        if (threadIdUUID == null) {
            return ThreadId.fromBaseMessageId((MessageId)messageId);
        }
        return ThreadId.fromBaseMessageId((MessageId)CassandraMessageId.Factory.of(threadIdUUID));
    }

    private Statement selectStatement(CassandraMessageId messageId, Optional<CassandraId> mailboxId) {
        return (Statement)mailboxId.map(cassandraId -> this.select.bind().setUUID(CassandraMessageIds.MESSAGE_ID_LOWERCASE, messageId.get()).setUUID(CassandraMessageIds.MAILBOX_ID_LOWERCASE, cassandraId.asUuid())).orElseGet(() -> this.selectAll.bind().setUUID(CassandraMessageIds.MESSAGE_ID_LOWERCASE, messageId.get()));
    }
}

