/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.stream;

import junit.framework.TestCase;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.BodyDescriptorBuilder;
import org.apache.james.mime4j.stream.FallbackBodyDescriptorBuilder;
import org.apache.james.mime4j.stream.RawField;

public class FallbackBodyDescriptorBuilderTest
extends TestCase {
    public void testAddField() throws Exception {
        FallbackBodyDescriptorBuilder builder = new FallbackBodyDescriptorBuilder();
        builder.addField(new RawField("Content-Type ", "text/plain; charset=ISO-8859-1"));
        BodyDescriptor bd = builder.build();
        FallbackBodyDescriptorBuilderTest.assertEquals((String)"text/plain", (String)bd.getMimeType());
        FallbackBodyDescriptorBuilderTest.assertEquals((String)"ISO-8859-1", (String)bd.getCharset());
        builder.addField(new RawField("Content-Type ", "text/html; charset=us-ascii"));
        bd = builder.build();
        FallbackBodyDescriptorBuilderTest.assertEquals((String)"text/plain", (String)bd.getMimeType());
        FallbackBodyDescriptorBuilderTest.assertEquals((String)"ISO-8859-1", (String)bd.getCharset());
    }

    public void testGetMimeType() throws Exception {
        FallbackBodyDescriptorBuilder builder = new FallbackBodyDescriptorBuilder();
        builder.addField(new RawField("Content-Type ", "text/PLAIN"));
        BodyDescriptor bd = builder.build();
        FallbackBodyDescriptorBuilderTest.assertEquals((String)"text/plain", (String)bd.getMimeType());
        builder.reset();
        builder.addField(new RawField("content-type", "   TeXt / html   "));
        bd = builder.build();
        FallbackBodyDescriptorBuilderTest.assertEquals((String)"text/html", (String)bd.getMimeType());
        builder.reset();
        builder.addField(new RawField("CONTENT-TYPE", "   x-app/yada ;  param = yada"));
        bd = builder.build();
        FallbackBodyDescriptorBuilderTest.assertEquals((String)"x-app/yada", (String)bd.getMimeType());
        builder.reset();
        builder.addField(new RawField("CONTENT-TYPE", "   yada"));
        bd = builder.build();
        FallbackBodyDescriptorBuilderTest.assertEquals((String)"text/plain", (String)bd.getMimeType());
        builder.reset();
        builder.addField(new RawField("Content-Type ", "text/plain"));
        bd = builder.build();
        FallbackBodyDescriptorBuilderTest.assertEquals((String)"text/plain", (String)bd.getMimeType());
        builder.addField(new RawField("Content-Type ", "text/html"));
        bd = builder.build();
        FallbackBodyDescriptorBuilderTest.assertEquals((String)"text/plain", (String)bd.getMimeType());
        FallbackBodyDescriptorBuilder parent = new FallbackBodyDescriptorBuilder();
        parent.addField(new RawField("Content-Type", "mutlipart/alternative; boundary=foo"));
        BodyDescriptorBuilder child = parent.newChild();
        bd = child.build();
        FallbackBodyDescriptorBuilderTest.assertEquals((String)"text/plain", (String)bd.getMimeType());
        child.addField(new RawField("Content-Type", " child/type"));
        bd = child.build();
        FallbackBodyDescriptorBuilderTest.assertEquals((String)"child/type", (String)bd.getMimeType());
        parent.reset();
        parent.addField(new RawField("Content-Type", "multipart/digest; boundary=foo"));
        child = parent.newChild();
        bd = child.build();
        FallbackBodyDescriptorBuilderTest.assertEquals((String)"message/rfc822", (String)bd.getMimeType());
        child.addField(new RawField("Content-Type", " child/type"));
        bd = child.build();
        FallbackBodyDescriptorBuilderTest.assertEquals((String)"child/type", (String)bd.getMimeType());
    }

    public void testParameters() throws Exception {
        FallbackBodyDescriptorBuilder builder = new FallbackBodyDescriptorBuilder();
        BodyDescriptor bd = builder.build();
        FallbackBodyDescriptorBuilderTest.assertEquals((String)"us-ascii", (String)bd.getCharset());
        builder.addField(new RawField("Content-Type ", "text/type; charset=ISO-8859-1"));
        bd = builder.build();
        FallbackBodyDescriptorBuilderTest.assertEquals((String)"ISO-8859-1", (String)bd.getCharset());
        builder.reset();
        bd = builder.build();
        FallbackBodyDescriptorBuilderTest.assertEquals((String)"us-ascii", (String)bd.getCharset());
        builder.addField(new RawField("Content-Type ", "text/type"));
        bd = builder.build();
        FallbackBodyDescriptorBuilderTest.assertEquals((String)"us-ascii", (String)bd.getCharset());
        builder.reset();
        builder.addField(new RawField("Content-Type", "text/html; boundary=yada yada"));
        bd = builder.build();
        FallbackBodyDescriptorBuilderTest.assertNull((Object)bd.getBoundary());
        builder.reset();
        builder.addField(new RawField("Content-Type", "multipart/yada; boundary=yada"));
        bd = builder.build();
        FallbackBodyDescriptorBuilderTest.assertEquals((String)"yada", (String)bd.getBoundary());
        builder.reset();
        builder.addField(new RawField("Content-Type", "multipart/yada; boUNdarY= \"ya \\\"\\\"\tda \\\"\"; \tcharset\t =  \"\\\"hepp\\\"  =us\t-ascii\""));
        bd = builder.build();
        FallbackBodyDescriptorBuilderTest.assertEquals((String)"ya \"\"\tda \"", (String)bd.getBoundary());
        FallbackBodyDescriptorBuilderTest.assertEquals((String)"\"hepp\"  =us\t-ascii", (String)bd.getCharset());
    }

    public void testMultipartNoBoundary() throws Exception {
        FallbackBodyDescriptorBuilder builder = new FallbackBodyDescriptorBuilder();
        builder.addField(new RawField("Content-Type", "multipart/yada; "));
        BodyDescriptor bd = builder.build();
        FallbackBodyDescriptorBuilderTest.assertEquals((String)"text/plain", (String)bd.getMimeType());
    }

    public void testGetContentLength() throws Exception {
        FallbackBodyDescriptorBuilder builder = new FallbackBodyDescriptorBuilder();
        BodyDescriptor bd = builder.build();
        FallbackBodyDescriptorBuilderTest.assertEquals((long)-1L, (long)bd.getContentLength());
        builder.addField(new RawField("Content-Length", "9901"));
        bd = builder.build();
        FallbackBodyDescriptorBuilderTest.assertEquals((long)9901L, (long)bd.getContentLength());
        builder.addField(new RawField("Content-Length", "1239901"));
        bd = builder.build();
        FallbackBodyDescriptorBuilderTest.assertEquals((long)9901L, (long)bd.getContentLength());
    }

    public void testDoDefaultToUsAsciiWhenUntyped() throws Exception {
        FallbackBodyDescriptorBuilder builder = new FallbackBodyDescriptorBuilder();
        builder.addField(new RawField("To", "me@example.org"));
        BodyDescriptor bd = builder.build();
        FallbackBodyDescriptorBuilderTest.assertEquals((String)"us-ascii", (String)bd.getCharset());
    }

    public void testDoNotDefaultToUsAsciiForNonTextTypes() throws Exception {
        FallbackBodyDescriptorBuilder builder = new FallbackBodyDescriptorBuilder();
        builder.addField(new RawField("Content-Type", "image/png; name=blob.png"));
        BodyDescriptor bd = builder.build();
        FallbackBodyDescriptorBuilderTest.assertNull((Object)bd.getCharset());
    }
}

