/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.payload.request;

import java.io.IOException;
import java.util.Objects;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollRequest;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeRequestType;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeRequestVersion;
import org.apache.iotdb.service.rpc.thrift.TPipeSubscribeReq;

public class PipeSubscribePollReq
extends TPipeSubscribeReq {
    private transient SubscriptionPollRequest request;

    public SubscriptionPollRequest getRequest() {
        return this.request;
    }

    public static PipeSubscribePollReq toTPipeSubscribeReq(SubscriptionPollRequest request) throws IOException {
        PipeSubscribePollReq req = new PipeSubscribePollReq();
        req.request = request;
        req.version = PipeSubscribeRequestVersion.VERSION_1.getVersion();
        req.type = PipeSubscribeRequestType.POLL.getType();
        req.body = SubscriptionPollRequest.serialize(request);
        return req;
    }

    public static PipeSubscribePollReq fromTPipeSubscribeReq(TPipeSubscribeReq pollReq) {
        PipeSubscribePollReq req = new PipeSubscribePollReq();
        if (Objects.nonNull(pollReq.body) && pollReq.body.hasRemaining()) {
            req.request = SubscriptionPollRequest.deserialize(pollReq.body);
        }
        req.version = pollReq.version;
        req.type = pollReq.type;
        req.body = pollReq.body;
        return req;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeSubscribePollReq that = (PipeSubscribePollReq)((Object)obj);
        return Objects.equals(this.request, that.request) && this.version == that.version && this.type == that.type && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.request, this.request, this.version, this.type, this.body);
    }
}

