/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.subscription.topic;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.consensus.request.write.subscription.topic.DropTopicPlan;
import org.apache.iotdb.confignode.persistence.subscription.SubscriptionInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.subscription.AbstractOperateSubscriptionProcedure;
import org.apache.iotdb.confignode.procedure.impl.subscription.SubscriptionOperation;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropTopicProcedure
extends AbstractOperateSubscriptionProcedure {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropTopicProcedure.class);
    private String topicName;

    public DropTopicProcedure() {
    }

    public DropTopicProcedure(String topicName) {
        this.topicName = topicName;
    }

    @Override
    protected SubscriptionOperation getOperation() {
        return SubscriptionOperation.DROP_TOPIC;
    }

    @Override
    protected boolean executeFromValidate(ConfigNodeProcedureEnv env) throws SubscriptionException {
        LOGGER.info("DropTopicProcedure: executeFromValidate({})", (Object)this.topicName);
        ((SubscriptionInfo)this.subscriptionInfo.get()).validateBeforeDroppingTopic(this.topicName);
        return true;
    }

    @Override
    protected void executeFromOperateOnConfigNodes(ConfigNodeProcedureEnv env) throws SubscriptionException {
        TSStatus response;
        LOGGER.info("DropTopicProcedure: executeFromOperateOnConfigNodes({})", (Object)this.topicName);
        try {
            response = env.getConfigManager().getConsensusManager().write(new DropTopicPlan(this.topicName));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            response = new TSStatus(TSStatusCode.DROP_TOPIC_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new SubscriptionException(String.format("Failed to drop topic %s on config nodes, because %s", this.topicName, response));
        }
    }

    @Override
    protected void executeFromOperateOnDataNodes(ConfigNodeProcedureEnv env) {
        LOGGER.info("DropTopicProcedure: executeFromOperateOnDataNodes({})", (Object)this.topicName);
        List<TSStatus> statuses = env.dropSingleTopicOnDataNode(this.topicName);
        if (RpcUtils.squashResponseStatusList(statuses).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new SubscriptionException(String.format("Failed to drop topic %s on data nodes, because %s", this.topicName, statuses));
        }
    }

    @Override
    protected void rollbackFromValidate(ConfigNodeProcedureEnv env) {
        LOGGER.info("DropTopicProcedure: rollbackFromValidate({})", (Object)this.topicName);
    }

    @Override
    protected void rollbackFromOperateOnConfigNodes(ConfigNodeProcedureEnv env) {
        LOGGER.info("DropTopicProcedure: rollbackFromCreateOnConfigNodes({})", (Object)this.topicName);
    }

    @Override
    protected void rollbackFromOperateOnDataNodes(ConfigNodeProcedureEnv env) {
        LOGGER.info("DropTopicProcedure: rollbackFromCreateOnDataNodes({})", (Object)this.topicName);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.DROP_TOPIC_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.topicName, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.topicName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DropTopicProcedure that = (DropTopicProcedure)o;
        return Objects.equals(this.getProcId(), that.getProcId()) && Objects.equals(this.getCurrentState(), that.getCurrentState()) && this.getCycles() == that.getCycles() && Objects.equals(this.topicName, that.topicName);
    }

    public int hashCode() {
        return Objects.hash(this.getProcId(), this.getCurrentState(), this.getCycles(), this.topicName);
    }
}

