/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.performancestatistics.util;

import java.util.Collection;
import java.util.NavigableMap;
import java.util.TreeMap;

public class OrderedFixedSizeStructure<K extends Comparable<? super K>, V> {
    private static final int DEFAULT_SIZE = 30;
    private final int capacity;
    private final NavigableMap<K, V> map = new TreeMap();

    public OrderedFixedSizeStructure() {
        this(30);
    }

    public OrderedFixedSizeStructure(int capacity) {
        this.capacity = capacity;
    }

    public void put(K key, V value) {
        if (this.map.size() < this.capacity) {
            this.map.put(key, value);
            return;
        }
        if (((Comparable)this.map.firstKey()).compareTo(key) < 0) {
            this.map.pollFirstEntry();
            this.map.put(key, value);
        }
    }

    public Collection<V> values() {
        return this.map.values();
    }
}

