/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.performancestatistics;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.ignite.internal.performancestatistics.handlers.CacheOperationsHandler;
import org.apache.ignite.internal.performancestatistics.handlers.ClusterInfoHandler;
import org.apache.ignite.internal.performancestatistics.handlers.ComputeHandler;
import org.apache.ignite.internal.performancestatistics.handlers.IgnitePerformanceStatisticsHandler;
import org.apache.ignite.internal.performancestatistics.handlers.QueryHandler;
import org.apache.ignite.internal.performancestatistics.handlers.TransactionsHandler;
import org.apache.ignite.internal.performancestatistics.util.Utils;
import org.apache.ignite.internal.processors.performancestatistics.FilePerformanceStatisticsReader;
import org.apache.ignite.internal.processors.performancestatistics.PerformanceStatisticsHandler;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;

public class PerformanceStatisticsReportBuilder {
    private static final String REPORT_RESOURCE_NAME = "report.zip";

    public static void main(String ... args) throws Exception {
        String filesDir = PerformanceStatisticsReportBuilder.parseArguments(args);
        String resDir = PerformanceStatisticsReportBuilder.createResultDir(filesDir);
        PerformanceStatisticsReportBuilder.createReport(filesDir, resDir);
        System.out.println("Report created [dir=" + resDir + "]" + U.nl() + "Open '" + resDir + "/index.html' in browser to see the report.");
    }

    private static String parseArguments(String[] args) {
        if (args == null || args.length == 0 || "--help".equalsIgnoreCase(args[0]) || "-h".equalsIgnoreCase(args[0])) {
            System.out.println("The script is used to create a performance report from performance statistics files." + U.nl() + U.nl() + "Usage: build-report.sh path_to_files" + U.nl() + U.nl() + "The path should contain performance statistics files collected from the cluster." + U.nl() + "Performance statistics file name mask: node-${sys:nodeId}.prf" + U.nl() + "The report will be created at files path with new directory: path_to_files/report_yyyy-MM-dd_HH-mm-ss/" + U.nl() + "Open 'report_yyyy-MM-dd_HH-mm-ss/index.html' in browser to see the report.");
            System.exit(0);
        }
        A.ensure((args.length <= 1 ? 1 : 0) != 0, (String)("Too much arguments [args=" + Arrays.toString(args) + ']'));
        String filesDir = args[0];
        File dir = new File(filesDir);
        A.ensure((boolean)dir.exists(), (String)"Performance statistics files directory does not exists.");
        A.ensure((boolean)dir.isDirectory(), (String)"Performance statistics files directory is not a directory.");
        return filesDir;
    }

    private static void createReport(String filesDir, String resDir) throws Exception {
        PerformanceStatisticsHandler[] handlers = new IgnitePerformanceStatisticsHandler[]{new QueryHandler(), new CacheOperationsHandler(), new TransactionsHandler(), new ComputeHandler(), new ClusterInfoHandler()};
        new FilePerformanceStatisticsReader(handlers).read(Collections.singletonList(new File(filesDir)));
        ObjectNode dataJson = Utils.MAPPER.createObjectNode();
        for (PerformanceStatisticsHandler handler : handlers) {
            handler.results().forEach((arg_0, arg_1) -> ((ObjectNode)dataJson).set(arg_0, arg_1));
        }
        PerformanceStatisticsReportBuilder.writeJsonToFile(resDir + "/data/data.json", (JsonNode)dataJson);
        PerformanceStatisticsReportBuilder.jsonToJsVar(resDir + "/data/data.json", "REPORT_DATA");
        PerformanceStatisticsReportBuilder.copyReportSources(resDir);
    }

    private static String createResultDir(String filesDir) throws IOException {
        String postfix = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
        String resDir = Files.createDirectory(new File(filesDir, "report_" + postfix).toPath(), new FileAttribute[0]).toAbsolutePath().toString();
        Files.createDirectory(new File(resDir, "data").toPath(), new FileAttribute[0]);
        return resDir;
    }

    public static void writeJsonToFile(String fileName, JsonNode json) throws IOException {
        ObjectWriter writer = new ObjectMapper().writer((PrettyPrinter)new DefaultPrettyPrinter());
        File file = new File(fileName);
        writer.writeValue(file, (Object)json);
    }

    public static void jsonToJsVar(String fileName, String varName) throws IOException {
        File jsonFile = new File(fileName);
        File jsFile = new File(fileName + ".js");
        try (BufferedWriter fileWriter = new BufferedWriter(new FileWriter(jsFile));){
            fileWriter.write("var " + varName + " = ");
            try (BufferedReader reader = new BufferedReader(new FileReader(jsonFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    fileWriter.write(line);
                    fileWriter.newLine();
                }
            }
        }
        jsonFile.delete();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void copyReportSources(String resDir) throws Exception {
        try (InputStream in = PerformanceStatisticsReportBuilder.class.getClassLoader().getResourceAsStream(REPORT_RESOURCE_NAME);){
            if (in == null) {
                System.err.println("Run from IDE require custom maven assembly to create UI resources (try to package 'ignite-performance-statistics-ext' module or set up executing 'package' phase before build). The report sources will not be copied to the result directory.");
                return;
            }
            try (ZipInputStream zip = new ZipInputStream(in);){
                ZipEntry entry;
                while ((entry = zip.getNextEntry()) != null) {
                    FileOutputStream out;
                    block39: {
                        File entryDestination = new File(resDir, entry.getName());
                        if (entry.isDirectory()) {
                            entryDestination.mkdirs();
                            continue;
                        }
                        entryDestination.getParentFile().mkdirs();
                        out = new FileOutputStream(entryDestination);
                        Throwable throwable = null;
                        try {
                            IOUtils.copy((InputStream)zip, (OutputStream)out);
                            if (out == null) continue;
                            if (throwable == null) break block39;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (out == null) throw throwable3;
                                if (throwable != null) {
                                    try {
                                        ((OutputStream)out).close();
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                }
                                ((OutputStream)out).close();
                                throw throwable3;
                            }
                        }
                        try {
                            ((OutputStream)out).close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    ((OutputStream)out).close();
                }
                return;
            }
        }
    }
}

