/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.internal;

import java.nio.channels.SelectableChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.util.nio.GridCommunicationClient;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.spi.IgniteSpiTimeoutObject;

public class HandshakeTimeoutObject<T>
implements IgniteSpiTimeoutObject {
    private final IgniteUuid id = IgniteUuid.randomUuid();
    private final T obj;
    private final long endTime;
    private final AtomicBoolean done = new AtomicBoolean();

    public HandshakeTimeoutObject(T obj, long endTime) {
        assert (obj != null);
        assert (obj instanceof GridCommunicationClient || obj instanceof SelectableChannel);
        assert (endTime > 0L);
        this.obj = obj;
        this.endTime = endTime;
    }

    public boolean cancel() {
        return this.done.compareAndSet(false, true);
    }

    @Override
    public void onTimeout() {
        if (this.done.compareAndSet(false, true)) {
            if (this.obj instanceof GridCommunicationClient) {
                ((GridCommunicationClient)this.obj).forceClose();
            } else {
                U.closeQuiet((AutoCloseable)this.obj);
            }
        }
    }

    @Override
    public long endTime() {
        return this.endTime;
    }

    @Override
    public IgniteUuid id() {
        return this.id;
    }

    public String toString() {
        return S.toString(HandshakeTimeoutObject.class, this);
    }
}

