/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.systemview;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.systemview.VisorSystemViewTask;

public class VisorSystemViewTaskResult
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private List<List<?>> rows;
    private List<String> attrs;
    List<VisorSystemViewTask.SimpleType> types;

    public VisorSystemViewTaskResult() {
    }

    public VisorSystemViewTaskResult(List<String> attrs, List<VisorSystemViewTask.SimpleType> types, List<List<?>> rows) {
        this.attrs = attrs;
        this.types = types;
        this.rows = rows;
    }

    public List<String> attributes() {
        return this.attrs;
    }

    public List<List<?>> rows() {
        return this.rows;
    }

    public List<VisorSystemViewTask.SimpleType> types() {
        return this.types;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeCollection(out, this.attrs);
        U.writeCollection(out, this.types);
        out.writeInt(this.rows.size());
        for (List<?> row : this.rows) {
            U.writeCollection(out, row);
        }
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.attrs = U.readList(in);
        this.types = U.readList(in);
        int rowsCnt = in.readInt();
        ArrayList rows = new ArrayList(rowsCnt);
        for (int i = 0; i < rowsCnt; ++i) {
            rows.add(U.readList(in));
        }
        this.rows = rows;
    }
}

