/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.util.Collection;
import java.util.List;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.node.VisorCacheRebalanceCollectorJobResult;
import org.apache.ignite.internal.visor.node.VisorCacheRebalanceCollectorTaskArg;
import org.apache.ignite.internal.visor.node.VisorCacheRebalanceCollectorTaskResult;
import org.apache.ignite.internal.visor.node.VisorNodeBaselineStatus;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorCacheRebalanceCollectorTask
extends VisorMultiNodeTask<VisorCacheRebalanceCollectorTaskArg, VisorCacheRebalanceCollectorTaskResult, VisorCacheRebalanceCollectorJobResult> {
    private static final long serialVersionUID = 0L;

    protected VisorCacheRebalanceCollectorJob job(VisorCacheRebalanceCollectorTaskArg arg) {
        return new VisorCacheRebalanceCollectorJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected VisorCacheRebalanceCollectorTaskResult reduce0(List<ComputeJobResult> results) {
        return this.reduce(new VisorCacheRebalanceCollectorTaskResult(), results);
    }

    protected VisorCacheRebalanceCollectorTaskResult reduce(VisorCacheRebalanceCollectorTaskResult taskRes, List<ComputeJobResult> results) {
        for (ComputeJobResult res : results) {
            VisorCacheRebalanceCollectorJobResult jobRes = (VisorCacheRebalanceCollectorJobResult)res.getData();
            if (jobRes == null) continue;
            if (res.getException() == null) {
                taskRes.getRebalance().put(res.getNode().id(), jobRes.getRebalance());
            }
            taskRes.getBaseline().put(res.getNode().id(), jobRes.getBaseline());
        }
        return taskRes;
    }

    private static class VisorCacheRebalanceCollectorJob
    extends VisorJob<VisorCacheRebalanceCollectorTaskArg, VisorCacheRebalanceCollectorJobResult> {
        private static final long serialVersionUID = 0L;

        private VisorCacheRebalanceCollectorJob(VisorCacheRebalanceCollectorTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorCacheRebalanceCollectorJobResult run(VisorCacheRebalanceCollectorTaskArg arg) {
            VisorCacheRebalanceCollectorJobResult res = new VisorCacheRebalanceCollectorJobResult();
            long start0 = U.currentTimeMillis();
            try {
                int partitions = 0;
                double total = 0.0;
                double ready = 0.0;
                GridCacheProcessor cacheProc = this.ignite.context().cache();
                boolean rebalanceInProgress = false;
                for (CacheGroupContext grp : cacheProc.cacheGroups()) {
                    String cacheName = grp.config().getName();
                    if (VisorTaskUtils.isProxyCache(this.ignite, cacheName) || VisorTaskUtils.isRestartingCache(this.ignite, cacheName)) continue;
                    try {
                        GridCacheAdapter ca = cacheProc.internalCache(cacheName);
                        if (ca == null || !ca.context().started()) continue;
                        CacheMetrics cm = ca.localMetrics();
                        partitions += cm.getTotalPartitionsCount();
                        long keysTotal = cm.getEstimatedRebalancingKeys();
                        long keysReady = cm.getRebalancedKeys();
                        if (keysReady >= keysTotal) {
                            keysReady = Math.max(keysTotal - 1L, 0L);
                        }
                        total += (double)keysTotal;
                        ready += (double)keysReady;
                        if (cm.getRebalancingPartitionsCount() <= 0) continue;
                        rebalanceInProgress = true;
                    }
                    catch (IllegalArgumentException | IllegalStateException e) {
                        if (!this.debug || this.ignite.log() == null) continue;
                        this.ignite.log().error("Ignored cache group: " + grp.cacheOrGroupName(), e);
                    }
                }
                if (partitions == 0) {
                    res.setRebalance(-1.0);
                } else if (total == 0.0 && rebalanceInProgress) {
                    res.setRebalance(0.01);
                } else {
                    res.setRebalance(total > 0.0 && rebalanceInProgress ? Math.max(ready / total, 0.01) : 1.0);
                }
            }
            catch (Exception e) {
                res.setRebalance(-2.0);
                this.ignite.log().error("Failed to collect rebalance metrics", e);
            }
            if (GridCacheUtils.isPersistenceEnabled(this.ignite.configuration())) {
                IgniteClusterEx cluster = this.ignite.cluster();
                Object consistentId = this.ignite.localNode().consistentId();
                Collection<BaselineNode> baseline = cluster.currentBaselineTopology();
                if (baseline != null) {
                    boolean inBaseline = baseline.stream().anyMatch(n -> consistentId.equals(n.consistentId()));
                    res.setBaseline(inBaseline ? VisorNodeBaselineStatus.NODE_IN_BASELINE : VisorNodeBaselineStatus.NODE_NOT_IN_BASELINE);
                } else {
                    res.setBaseline(VisorNodeBaselineStatus.BASELINE_NOT_AVAILABLE);
                }
            } else {
                res.setBaseline(VisorNodeBaselineStatus.BASELINE_NOT_AVAILABLE);
            }
            if (this.debug) {
                VisorTaskUtils.log(this.ignite.log(), "Collected rebalance metrics", this.getClass(), start0);
            }
            return res;
        }

        public String toString() {
            return S.toString(VisorCacheRebalanceCollectorJob.class, this);
        }
    }
}

