/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.websession;

import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.cache.CacheEntryProcessor;
import org.apache.ignite.internal.processors.platform.websession.PlatformDotNetSessionData;
import org.apache.ignite.internal.util.typedef.internal.S;

public class PlatformDotNetSessionSetAndUnlockProcessor
implements CacheEntryProcessor<String, PlatformDotNetSessionData, Void>,
Binarylizable {
    private static final long serialVersionUID = 0L;
    private UUID lockNodeId;
    private long lockId;
    private boolean update;
    private Map<String, byte[]> items;
    private boolean isDiff;
    private byte[] staticData;
    private int timeout;

    public PlatformDotNetSessionSetAndUnlockProcessor(UUID lockNodeId, long lockId) {
        this(lockNodeId, lockId, false, null, false, null, 0);
    }

    public PlatformDotNetSessionSetAndUnlockProcessor(PlatformDotNetSessionData data) {
        this(data.lockNodeId(), data.lockId(), true, data.items(), true, data.staticObjects(), data.timeout());
    }

    public PlatformDotNetSessionSetAndUnlockProcessor(UUID lockNodeId, long lockId, boolean update, Map<String, byte[]> items, boolean isDiff, byte[] staticData, int timeout) {
        this.lockNodeId = lockNodeId;
        this.lockId = lockId;
        this.update = update;
        this.items = items;
        this.isDiff = isDiff;
        this.staticData = staticData;
        this.timeout = timeout;
    }

    public Void process(MutableEntry<String, PlatformDotNetSessionData> entry, Object ... args) throws EntryProcessorException {
        assert (entry.exists());
        PlatformDotNetSessionData data = (PlatformDotNetSessionData)entry.getValue();
        assert (data != null);
        data = this.update ? data.updateAndUnlock(this.lockNodeId, this.lockId, this.items, this.isDiff, this.staticData, this.timeout) : data.unlock(this.lockNodeId, this.lockId);
        entry.setValue((Object)data);
        return null;
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter raw = writer.rawWriter();
        raw.writeUuid(this.lockNodeId);
        raw.writeLong(this.lockId);
        raw.writeBoolean(this.update);
        if (this.update) {
            raw.writeBoolean(this.isDiff);
            raw.writeByteArray(this.staticData);
            raw.writeInt(this.timeout);
            if (this.items != null) {
                raw.writeInt(this.items.size());
                for (Map.Entry<String, byte[]> e : this.items.entrySet()) {
                    raw.writeString(e.getKey());
                    raw.writeByteArray(e.getValue());
                }
            } else {
                raw.writeInt(-1);
            }
        }
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader raw = reader.rawReader();
        this.lockNodeId = raw.readUuid();
        this.lockId = raw.readLong();
        this.update = raw.readBoolean();
        if (this.update) {
            this.isDiff = raw.readBoolean();
            this.staticData = raw.readByteArray();
            this.timeout = raw.readInt();
            int cnt = raw.readInt();
            if (cnt >= 0) {
                this.items = new TreeMap<String, byte[]>();
                for (int i = 0; i < cnt; ++i) {
                    this.items.put(raw.readString(), raw.readByteArray());
                }
            }
        }
    }

    public String toString() {
        return S.toString(PlatformDotNetSessionSetAndUnlockProcessor.class, this);
    }
}

