/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.marshaller;

import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.marshaller.ClientRequestFuture;
import org.apache.ignite.internal.processors.marshaller.MappedName;
import org.apache.ignite.internal.processors.marshaller.MappingExchangeResult;
import org.apache.ignite.internal.processors.marshaller.MappingProposedMessage;
import org.apache.ignite.internal.processors.marshaller.MarshallerMappingItem;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.jetbrains.annotations.Nullable;

public final class MarshallerMappingTransport {
    private final GridKernalContext ctx;
    private final GridDiscoveryManager discoMgr;
    private final ConcurrentMap<MarshallerMappingItem, GridFutureAdapter<MappingExchangeResult>> mappingExchSyncMap;
    private final ConcurrentMap<MarshallerMappingItem, ClientRequestFuture> clientReqSyncMap;
    private volatile boolean stopping;

    MarshallerMappingTransport(GridKernalContext ctx, ConcurrentMap<MarshallerMappingItem, GridFutureAdapter<MappingExchangeResult>> mappingExchSyncMap, ConcurrentMap<MarshallerMappingItem, ClientRequestFuture> clientReqSyncMap) {
        this.ctx = ctx;
        this.discoMgr = ctx.discovery();
        this.mappingExchSyncMap = mappingExchSyncMap;
        this.clientReqSyncMap = clientReqSyncMap;
        this.stopping = false;
    }

    public GridFutureAdapter<MappingExchangeResult> awaitMappingAcceptance(MarshallerMappingItem item, ConcurrentMap<Integer, MappedName> cache) {
        MappingExchangeResultFuture fut = new MappingExchangeResultFuture(item);
        GridFutureAdapter<MappingExchangeResult> oldFut = this.mappingExchSyncMap.putIfAbsent(item, fut);
        if (oldFut != null) {
            return oldFut;
        }
        MappedName mappedName = (MappedName)cache.get(item.typeId());
        assert (mappedName != null);
        if (mappedName.accepted()) {
            fut.onDone(MappingExchangeResult.createSuccessfulResult(mappedName.className()));
        }
        return fut;
    }

    public GridFutureAdapter<MappingExchangeResult> proposeMapping(MarshallerMappingItem item, ConcurrentMap<Integer, MappedName> cache) throws IgniteCheckedException {
        MappingExchangeResultFuture fut = new MappingExchangeResultFuture(item);
        GridFutureAdapter<MappingExchangeResult> oldFut = this.mappingExchSyncMap.putIfAbsent(item, fut);
        if (oldFut != null) {
            return oldFut;
        }
        MappedName mapping = (MappedName)cache.get(item.typeId());
        if (mapping != null) {
            String mappedClsName = mapping.className();
            if (!mappedClsName.equals(item.className())) {
                fut.onDone(MappingExchangeResult.createFailureResult(this.duplicateMappingException(item, mappedClsName)));
            } else if (mapping.accepted()) {
                fut.onDone(MappingExchangeResult.createSuccessfulResult(mappedClsName));
            } else if (this.stopping) {
                fut.onDone(MappingExchangeResult.createExchangeDisabledResult());
            }
            return fut;
        }
        MappingProposedMessage msg = new MappingProposedMessage(item, this.discoMgr.localNode().id());
        this.discoMgr.sendCustomEvent(msg);
        return fut;
    }

    public GridFutureAdapter<MappingExchangeResult> requestMapping(MarshallerMappingItem item, ConcurrentMap<Integer, MappedName> cache) {
        ClientRequestFuture newFut = new ClientRequestFuture(this.ctx, item, this.clientReqSyncMap);
        ClientRequestFuture oldFut = this.clientReqSyncMap.putIfAbsent(item, newFut);
        if (oldFut != null) {
            return oldFut;
        }
        MappedName mappedName = (MappedName)cache.get(item.typeId());
        if (mappedName != null) {
            newFut.onDone(MappingExchangeResult.createSuccessfulResult(mappedName.className()));
            return newFut;
        }
        newFut.requestMapping();
        return newFut;
    }

    private IgniteCheckedException duplicateMappingException(MarshallerMappingItem item, String mappedClsName) {
        return new IgniteCheckedException("Duplicate ID [platformId=" + item.platformId() + ", typeId=" + item.typeId() + ", oldCls=" + mappedClsName + ", newCls=" + item.className() + "]");
    }

    public void markStopping() {
        this.stopping = true;
    }

    public boolean stopping() {
        return this.stopping;
    }

    private class MappingExchangeResultFuture
    extends GridFutureAdapter<MappingExchangeResult> {
        private final MarshallerMappingItem mappingItem;

        private MappingExchangeResultFuture(MarshallerMappingItem mappingItem) {
            this.mappingItem = mappingItem;
        }

        @Override
        public boolean onDone(@Nullable MappingExchangeResult res, @Nullable Throwable err) {
            assert (res != null);
            boolean done = super.onDone(res, null);
            if (done) {
                MarshallerMappingTransport.this.mappingExchSyncMap.remove(this.mappingItem, this);
            }
            return done;
        }
    }
}

