/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.binary;

import java.util.Collection;
import java.util.Map;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.jetbrains.annotations.Nullable;

public class IgniteBinaryImpl
implements IgniteBinary {
    private GridKernalContext ctx;
    private IgniteCacheObjectProcessor proc;

    public IgniteBinaryImpl(GridKernalContext ctx, IgniteCacheObjectProcessor proc) {
        this.ctx = ctx;
        this.proc = proc;
    }

    @Override
    public int typeId(String typeName) {
        this.guard();
        try {
            int n = this.proc.typeId(typeName);
            return n;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <T> T toBinary(@Nullable Object obj) throws BinaryObjectException {
        this.guard();
        try {
            Object object = this.proc.marshalToBinary(obj, false);
            return (T)object;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public BinaryObjectBuilder builder(String typeName) {
        this.guard();
        try {
            BinaryObjectBuilder binaryObjectBuilder = this.proc.builder(typeName);
            return binaryObjectBuilder;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public BinaryObjectBuilder builder(BinaryObject binaryObj) {
        this.guard();
        try {
            BinaryObjectBuilder binaryObjectBuilder = this.proc.builder(binaryObj);
            return binaryObjectBuilder;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public BinaryType type(Class<?> cls) throws BinaryObjectException {
        this.guard();
        try {
            BinaryType binaryType = this.proc.metadata(this.proc.typeId(cls.getName()));
            return binaryType;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public BinaryType type(String typeName) throws BinaryObjectException {
        this.guard();
        try {
            BinaryType binaryType = this.proc.metadata(this.proc.typeId(typeName));
            return binaryType;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public BinaryType type(int typeId) throws BinaryObjectException {
        this.guard();
        try {
            BinaryType binaryType = this.proc.metadata(typeId);
            return binaryType;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public Collection<BinaryType> types() throws BinaryObjectException {
        this.guard();
        try {
            Collection<BinaryType> collection = this.proc.metadata();
            return collection;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BinaryObject buildEnum(String typeName, int ord) {
        this.guard();
        try {
            BinaryObject binaryObject = this.proc.buildEnum(typeName, ord);
            return binaryObject;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BinaryObject buildEnum(String typeName, String name) {
        this.guard();
        try {
            BinaryObject binaryObject = this.proc.buildEnum(typeName, name);
            return binaryObject;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BinaryType registerEnum(String typeName, Map<String, Integer> vals) {
        this.guard();
        try {
            BinaryType binaryType = this.proc.registerEnum(typeName, vals);
            return binaryType;
        }
        finally {
            this.unguard();
        }
    }

    public IgniteCacheObjectProcessor processor() {
        return this.proc;
    }

    private void guard() {
        this.ctx.gateway().readLock();
    }

    private void unguard() {
        this.ctx.gateway().readUnlock();
    }
}

