/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.cache.Cache;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.store.CacheStore;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.jetbrains.annotations.Nullable;

public class CacheStoreBalancingWrapper<K, V>
implements CacheStore<K, V> {
    public static final int DFLT_LOAD_ALL_THRESHOLD = 5;
    private CacheStore<K, V> delegate;
    private ConcurrentMap<K, LoadFuture> pendingLoads = new ConcurrentHashMap<K, LoadFuture>();
    private int loadAllThreshold = 5;

    public CacheStoreBalancingWrapper(CacheStore<K, V> delegate) {
        this.delegate = delegate;
    }

    public CacheStoreBalancingWrapper(CacheStore<K, V> delegate, int loadAllThreshold) {
        this.delegate = delegate;
        this.loadAllThreshold = loadAllThreshold;
    }

    public int loadAllThreshold() {
        return this.loadAllThreshold;
    }

    @Nullable
    public V load(K key) {
        LoadFuture fut = (LoadFuture)this.pendingLoads.get(key);
        try {
            if (fut != null) {
                return fut.get(key);
            }
            fut = new LoadFuture();
            LoadFuture old = this.pendingLoads.putIfAbsent(key, fut);
            if (old != null) {
                return old.get(key);
            }
        }
        catch (IgniteCheckedException e) {
            throw new CacheLoaderException((Throwable)e);
        }
        try {
            Object val = this.delegate.load(key);
            fut.onComplete(key, val);
            return (V)val;
        }
        catch (Throwable e) {
            fut.onError(key, e);
            if (e instanceof Error) {
                throw e;
            }
            throw e;
        }
    }

    @Override
    public void loadCache(IgniteBiInClosure<K, V> clo, Object ... args) {
        this.delegate.loadCache(clo, args);
    }

    public Map<K, V> loadAll(Iterable<? extends K> keys) throws CacheLoaderException {
        assert (false);
        return this.delegate.loadAll(keys);
    }

    public void loadAll(Collection<? extends K> keys, IgniteBiInClosure<K, V> c) {
        assert (keys.size() <= this.loadAllThreshold) : this.loadAllThreshold;
        ArrayList<Object> needLoad = null;
        HashMap<Object, LoadFuture> pending = null;
        LoadFuture span = null;
        for (Object key : keys) {
            LoadFuture old;
            LoadFuture loadFuture = (LoadFuture)this.pendingLoads.get(key);
            if (loadFuture != null) {
                if (pending == null) {
                    pending = new HashMap<Object, LoadFuture>();
                }
                pending.put(key, loadFuture);
                continue;
            }
            if (span == null) {
                span = new LoadFuture();
            }
            if ((old = this.pendingLoads.putIfAbsent(key, span)) != null) {
                if (pending == null) {
                    pending = new HashMap();
                }
                pending.put(key, old);
                continue;
            }
            if (needLoad == null) {
                needLoad = new ArrayList<Object>(keys.size());
            }
            needLoad.add(key);
        }
        if (needLoad != null) {
            assert (!needLoad.isEmpty());
            assert (span != null);
            try {
                Map loaded = this.delegate.loadAll(needLoad);
                if (loaded != null) {
                    for (Map.Entry entry : loaded.entrySet()) {
                        c.apply(entry.getKey(), entry.getValue());
                    }
                }
                span.onComplete(needLoad, loaded);
            }
            catch (Throwable e) {
                span.onError(needLoad, e);
                if (e instanceof Error) {
                    throw e;
                }
                throw e;
            }
        }
        if (pending != null) {
            try {
                for (Map.Entry e : pending.entrySet()) {
                    Object k = e.getKey();
                    c.apply(k, ((LoadFuture)e.getValue()).get(k));
                }
            }
            catch (IgniteCheckedException e) {
                throw new CacheLoaderException((Throwable)e);
            }
        }
    }

    public void write(Cache.Entry<? extends K, ? extends V> entry) {
        this.delegate.write(entry);
    }

    public void writeAll(Collection<Cache.Entry<? extends K, ? extends V>> entries) {
        this.delegate.writeAll(entries);
    }

    public void delete(Object key) throws CacheWriterException {
        this.delegate.delete(key);
    }

    public void deleteAll(Collection<?> keys) throws CacheWriterException {
        this.delegate.deleteAll(keys);
    }

    @Override
    public void sessionEnd(boolean commit) {
        this.delegate.sessionEnd(commit);
    }

    public String toString() {
        return S.toString(CacheStoreBalancingWrapper.class, this);
    }

    private class LoadFuture
    extends GridFutureAdapter<Map<K, V>> {
        private volatile Collection<K> keys;

        @Override
        public boolean onDone(@Nullable Map<K, V> res, @Nullable Throwable err) {
            if (super.onDone(res, err)) {
                assert (this.keys != null);
                for (Object key : this.keys) {
                    CacheStoreBalancingWrapper.this.pendingLoads.remove(key, this);
                }
                return true;
            }
            return false;
        }

        public void onComplete(K key, V val) {
            this.onComplete(Collections.singletonList(key), F.asMap(key, val));
        }

        public void onComplete(Collection<K> keys, Map<K, V> res) {
            this.keys = keys;
            this.onDone(res);
        }

        public void onError(K key, Throwable err) {
            this.keys = Collections.singletonList(key);
            this.onDone(err);
        }

        public void onError(Collection<K> keys, Throwable err) {
            this.keys = keys;
            this.onDone(err);
        }

        public V get(K key) throws IgniteCheckedException {
            return ((Map)this.get()).get(key);
        }
    }
}

