/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.storage.logit.storage.file;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.raft.jraft.storage.logit.storage.file.AbstractFile;

public class FileHeader {
    private static final IgniteLogger LOG = Loggers.forClass(FileHeader.class);
    private static final long RESERVED_FLAG = 0L;
    public static final int HEADER_SIZE = 26;
    public static final long BLANK_OFFSET_INDEX = -99L;
    private volatile long FirstLogIndex = -99L;
    private long FileFromOffset = -1L;
    private volatile long LastLogIndex = -99L;
    private static final byte MAGIC = 32;

    public ByteBuffer encode() {
        ByteBuffer buffer = ByteBuffer.allocate(26).order(AbstractFile.LOGIT_BYTE_ORDER);
        buffer.put((byte)32);
        buffer.put((byte)32);
        buffer.putLong(this.FirstLogIndex);
        buffer.putLong(this.FileFromOffset);
        buffer.putLong(0L);
        buffer.flip();
        return buffer;
    }

    public boolean decode(ByteBuffer buffer) {
        if (buffer == null || buffer.remaining() < 26) {
            LOG.error("Fail to decode file header, invalid buffer length: {}", buffer == null ? 0 : buffer.remaining());
            return false;
        }
        assert (buffer.order() == AbstractFile.LOGIT_BYTE_ORDER);
        if (buffer.get() != 32) {
            return false;
        }
        if (buffer.get() != 32) {
            return false;
        }
        this.FirstLogIndex = buffer.getLong();
        this.FileFromOffset = buffer.getLong();
        return true;
    }

    public long getFirstLogIndex() {
        return this.FirstLogIndex;
    }

    public void setFirstLogIndex(long firstLogIndex) {
        this.FirstLogIndex = firstLogIndex;
    }

    public long getFileFromOffset() {
        return this.FileFromOffset;
    }

    public void setFileFromOffset(long fileFromOffset) {
        this.FileFromOffset = fileFromOffset;
    }

    public long getLastLogIndex() {
        return this.LastLogIndex;
    }

    public void setLastLogIndex(long lastLogIndex) {
        this.LastLogIndex = lastLogIndex;
    }

    public int getHeaderSize() {
        return 26;
    }

    public boolean isBlank() {
        return this.FirstLogIndex == -99L;
    }
}

