/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rel;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite3.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite3.internal.sql.engine.rel.ProjectableFilterableTableScan;
import org.apache.ignite3.internal.sql.engine.rel.SourceAwareIgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.explain.IgniteRelWriter;
import org.apache.ignite3.internal.sql.engine.trait.TraitUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteTableScan
extends ProjectableFilterableTableScan
implements SourceAwareIgniteRel {
    private static final String REL_TYPE_NAME = "TableScan";
    private final long sourceId;

    public IgniteTableScan(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE}));
        Object srcIdObj = input.get("sourceId");
        this.sourceId = srcIdObj != null ? ((Number)srcIdObj).longValue() : -1L;
    }

    public IgniteTableScan(RelOptCluster cluster, RelTraitSet traits, RelOptTable tbl) {
        this(cluster, traits, tbl, List.of(), null, null, null, null);
    }

    public IgniteTableScan(RelOptCluster cluster, RelTraitSet traits, RelOptTable tbl, List<RelHint> hints, @Nullable List<String> names, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable ImmutableIntList requiredColumns) {
        this(-1L, cluster, traits, hints, tbl, names, proj, cond, requiredColumns);
    }

    public IgniteTableScan(long sourceId, RelOptCluster cluster, RelTraitSet traits, List<RelHint> hints, RelOptTable tbl, @Nullable List<String> names, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable ImmutableIntList requiredColumns) {
        super(cluster, traits, hints, tbl, names, proj, cond, requiredColumns);
        this.sourceId = sourceId;
    }

    @Override
    public long sourceId() {
        return this.sourceId;
    }

    @Override
    protected RelWriter explainTerms0(RelWriter pw) {
        return super.explainTerms0(pw).itemIf("sourceId", (Object)this.sourceId, this.sourceId != -1L);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public IgniteRel clone(long sourceId) {
        return new IgniteTableScan(sourceId, this.getCluster(), this.getTraitSet(), (List<RelHint>)this.getHints(), this.getTable(), this.names, this.projects, this.condition, this.requiredColumns);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteTableScan(this.sourceId, cluster, this.getTraitSet(), (List<RelHint>)this.getHints(), this.getTable(), this.names, this.projects, this.condition, this.requiredColumns);
    }

    @Override
    protected ProjectableFilterableTableScan copy(@Nullable List<RexNode> newProjects, @Nullable RexNode newCondition) {
        return new IgniteTableScan(this.sourceId, this.getCluster(), this.getTraitSet(), (List<RelHint>)this.getHints(), this.getTable(), this.names, newProjects, newCondition, this.requiredColumns);
    }

    public IgniteTableScan withHints(List<RelHint> hintList) {
        return new IgniteTableScan(this.sourceId, this.getCluster(), this.getTraitSet(), hintList, this.getTable(), this.names, this.projects, this.condition, this.requiredColumns);
    }

    public String getRelTypeName() {
        return REL_TYPE_NAME;
    }

    @Override
    public IgniteRelWriter explain(IgniteRelWriter writer) {
        return this.explainAttributes(writer);
    }
}

