/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest;

import org.jetbrains.annotations.Nullable;

public class PathAvailability {
    private final boolean isAvailable;
    @Nullable
    private final String unavailableTitle;
    @Nullable
    private final String unavailableReason;

    private PathAvailability(boolean isAvailable, @Nullable String unavailableTitle, @Nullable String unavailableReason) {
        this.isAvailable = isAvailable;
        this.unavailableTitle = unavailableTitle;
        this.unavailableReason = unavailableReason;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    @Nullable
    public String unavailableTitle() {
        return this.unavailableTitle;
    }

    @Nullable
    public String unavailableReason() {
        return this.unavailableReason;
    }

    public static PathAvailability available() {
        return new PathAvailability(true, null, null);
    }

    public static PathAvailability unavailable(String title, String reason) {
        return new PathAvailability(false, title, reason);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathAvailability that = (PathAvailability)o;
        if (this.isAvailable != that.isAvailable) {
            return false;
        }
        if (this.unavailableTitle != null ? !this.unavailableTitle.equals(that.unavailableTitle) : that.unavailableTitle != null) {
            return false;
        }
        return this.unavailableReason != null ? this.unavailableReason.equals(that.unavailableReason) : that.unavailableReason == null;
    }

    public int hashCode() {
        int result = this.isAvailable ? 1 : 0;
        result = 31 * result + (this.unavailableTitle != null ? this.unavailableTitle.hashCode() : 0);
        result = 31 * result + (this.unavailableReason != null ? this.unavailableReason.hashCode() : 0);
        return result;
    }
}

