/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.tx.PendingTxPartitionEnlistment;
import org.apache.ignite.internal.tx.TransactionIds;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.impl.IgniteAbstractTransactionImpl;
import org.apache.ignite.internal.tx.impl.TransactionsExceptionMapperUtil;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.tx.TransactionException;
import org.jetbrains.annotations.Nullable;

public class ReadWriteTransactionImpl
extends IgniteAbstractTransactionImpl {
    private final boolean colocationEnabled;
    private static final AtomicReferenceFieldUpdater<ReadWriteTransactionImpl, ReplicationGroupId> COMMIT_PART_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ReadWriteTransactionImpl.class, ReplicationGroupId.class, "commitPart");
    private final Map<ReplicationGroupId, PendingTxPartitionEnlistment> enlisted = new ConcurrentHashMap<ReplicationGroupId, PendingTxPartitionEnlistment>();
    @Nullable
    private volatile ReplicationGroupId commitPart;
    private final ReentrantReadWriteLock enlistPartitionLock = new ReentrantReadWriteLock();
    private volatile CompletableFuture<Void> finishFuture;
    private boolean killed;

    public ReadWriteTransactionImpl(TxManager txManager, HybridTimestampTracker observableTsTracker, UUID id, UUID txCoordinatorId, boolean implicit, long timeout, boolean colocationEnabled) {
        super(txManager, observableTsTracker, id, txCoordinatorId, implicit, timeout);
        this.colocationEnabled = colocationEnabled;
    }

    @Override
    public boolean assignCommitPartition(ReplicationGroupId commitPartitionId) {
        this.assertReplicationGroupType(commitPartitionId);
        return COMMIT_PART_UPDATER.compareAndSet(this, null, commitPartitionId);
    }

    @Override
    public ReplicationGroupId commitPartition() {
        return this.commitPart;
    }

    @Override
    public PendingTxPartitionEnlistment enlistedPartition(ReplicationGroupId partGroupId) {
        this.assertReplicationGroupType(partGroupId);
        return this.enlisted.get(partGroupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enlist(ReplicationGroupId replicationGroupId, int tableId, String primaryNodeConsistentId, long consistencyToken) {
        this.assertReplicationGroupType(replicationGroupId);
        if (!this.enlistPartitionLock.readLock().tryLock()) {
            this.failEnlist();
            assert (false);
        }
        try {
            this.checkEnlistPossibility();
            PendingTxPartitionEnlistment enlistment = this.enlisted.computeIfAbsent(replicationGroupId, k -> new PendingTxPartitionEnlistment(primaryNodeConsistentId, consistencyToken));
            enlistment.addTableId(tableId);
        }
        finally {
            this.enlistPartitionLock.readLock().unlock();
        }
    }

    private void assertReplicationGroupType(ReplicationGroupId replicationGroupId) {
        assert (!this.colocationEnabled ? replicationGroupId instanceof TablePartitionId : replicationGroupId instanceof ZonePartitionId) : "Invalid replication group type: " + String.valueOf(replicationGroupId.getClass());
    }

    private void failEnlist() {
        throw new TransactionException(ErrorGroups.Transactions.TX_ALREADY_FINISHED_ERR, IgniteStringFormatter.format((String)"Transaction is already finished [id={}, state={}].", (Object[])new Object[]{this.id(), this.state()}));
    }

    private void checkEnlistPossibility() {
        if (this.isFinishingOrFinished()) {
            this.failEnlist();
        }
    }

    public CompletableFuture<Void> commitAsync() {
        return TransactionsExceptionMapperUtil.convertToPublicFuture(this.finish(true, null, false, false), ErrorGroups.Transactions.TX_COMMIT_ERR);
    }

    public CompletableFuture<Void> rollbackAsync() {
        return TransactionsExceptionMapperUtil.convertToPublicFuture(this.finish(false, null, false, false), ErrorGroups.Transactions.TX_ROLLBACK_ERR);
    }

    @Override
    public CompletableFuture<Void> rollbackTimeoutExceededAsync() {
        return TransactionsExceptionMapperUtil.convertToPublicFuture(this.finish(false, null, false, true), ErrorGroups.Transactions.TX_ROLLBACK_ERR);
    }

    @Override
    public CompletableFuture<Void> finish(boolean commit, @Nullable HybridTimestamp executionTimestamp, boolean full, boolean timeoutExceeded) {
        assert (!commit || !timeoutExceeded) : "Transaction cannot commit with timeout exceeded.";
        if (this.finishFuture != null) {
            return this.finishFuture;
        }
        return this.finishInternal(commit, executionTimestamp, full, true, timeoutExceeded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> finishInternal(boolean commit, @Nullable HybridTimestamp executionTimestamp, boolean full, boolean isComplete, boolean timeoutExceeded) {
        this.enlistPartitionLock.writeLock().lock();
        try {
            if (this.finishFuture == null) {
                if (this.killed) {
                    if (isComplete) {
                        this.finishFuture = CompletableFutures.nullCompletedFuture();
                        CompletableFuture<Void> completableFuture = CompletableFuture.failedFuture((Throwable)new TransactionException(ErrorGroups.Transactions.TX_ALREADY_FINISHED_ERR, IgniteStringFormatter.format((String)"Transaction is killed [id={}, state={}].", (Object[])new Object[]{this.id(), this.state()})));
                        return completableFuture;
                    }
                    CompletableFuture completableFuture = CompletableFutures.nullCompletedFuture();
                    return completableFuture;
                }
                if (full) {
                    this.txManager.finishFull(this.observableTsTracker, this.id(), executionTimestamp, commit, timeoutExceeded);
                    if (isComplete) {
                        this.finishFuture = CompletableFutures.nullCompletedFuture();
                        this.timeoutExceeded = timeoutExceeded;
                    } else {
                        this.killed = true;
                    }
                } else {
                    CompletableFuture<Void> finishFutureInternal = this.txManager.finish(this.observableTsTracker, this.commitPart, commit, timeoutExceeded, false, this.enlisted, this.id());
                    if (isComplete) {
                        this.finishFuture = finishFutureInternal.handle((unused, throwable) -> null);
                        this.timeoutExceeded = timeoutExceeded;
                    } else {
                        this.killed = true;
                    }
                    CompletableFuture<Void> completableFuture = finishFutureInternal;
                    return completableFuture;
                }
            }
            CompletableFuture<Void> completableFuture = this.finishFuture;
            return completableFuture;
        }
        finally {
            this.enlistPartitionLock.writeLock().unlock();
        }
    }

    @Override
    public boolean isFinishingOrFinished() {
        return this.finishFuture != null;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public HybridTimestamp readTimestamp() {
        return null;
    }

    @Override
    public HybridTimestamp schemaTimestamp() {
        return TransactionIds.beginTimestamp(this.id());
    }

    @Override
    public CompletableFuture<Void> kill() {
        return this.finishInternal(false, null, false, false, false);
    }

    @Override
    public boolean isRolledBackWithTimeoutExceeded() {
        this.enlistPartitionLock.readLock().lock();
        try {
            boolean bl = this.timeoutExceeded;
            return bl;
        }
        finally {
            this.enlistPartitionLock.readLock().unlock();
        }
    }

    public void fail(TransactionException e) {
        this.finishFuture = CompletableFuture.failedFuture((Throwable)e);
    }
}

