/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.message;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.compute.message.JobCancelRequest;
import org.apache.ignite.internal.compute.message.JobCancelRequestBuilder;
import org.apache.ignite.internal.compute.message.JobCancelRequestSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class JobCancelRequestImpl
implements JobCancelRequest,
Cloneable {
    public static final short GROUP_TYPE = 6;
    public static final short TYPE = 7;
    @IgniteToStringInclude
    private final UUID jobId;

    private JobCancelRequestImpl(UUID jobId) {
        this.jobId = jobId;
    }

    @Override
    public UUID jobId() {
        return this.jobId;
    }

    public MessageSerializer serializer() {
        return JobCancelRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 6;
    }

    public String toString() {
        return S.toString(JobCancelRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 7;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        JobCancelRequestImpl otherMessage = (JobCancelRequestImpl)other;
        return Objects.equals(this.jobId, otherMessage.jobId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.jobId);
        return result;
    }

    public JobCancelRequestImpl clone() {
        try {
            return (JobCancelRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static JobCancelRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements JobCancelRequestBuilder {
        private UUID jobId;

        private Builder() {
        }

        @Override
        public JobCancelRequestBuilder jobId(UUID jobId) {
            Objects.requireNonNull(jobId, "jobId is not marked @Nullable");
            this.jobId = jobId;
            return this;
        }

        @Override
        public UUID jobId() {
            return this.jobId;
        }

        @Override
        public JobCancelRequest build() {
            return new JobCancelRequestImpl(Objects.requireNonNull(this.jobId, "jobId is not marked @Nullable"));
        }
    }
}

