/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.cluster.unit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.Call;
import org.apache.ignite.internal.cli.call.cluster.unit.DeployUnitCallInput;
import org.apache.ignite.internal.cli.call.cluster.unit.DeployUnitClient;
import org.apache.ignite.internal.cli.call.cluster.unit.TrackingCallback;
import org.apache.ignite.internal.cli.core.call.AsyncCall;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.call.ProgressTracker;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.exception.UnitAlreadyExistsException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.internal.cli.core.style.component.MessageUiComponent;
import org.apache.ignite.internal.cli.core.style.element.UiElements;
import org.apache.ignite.rest.client.invoker.ApiClient;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.DeployMode;
import org.jetbrains.annotations.Nullable;

public class DeployUnitCall
implements AsyncCall<DeployUnitCallInput, String> {
    private final ProgressTracker tracker;
    private final ApiClientFactory clientFactory;

    DeployUnitCall(ProgressTracker tracker, ApiClientFactory clientFactory) {
        this.tracker = tracker;
        this.clientFactory = clientFactory;
    }

    @Override
    public CompletableFuture<CallOutput<String>> execute(DeployUnitCallInput input) {
        List<File> files;
        ApiClient apiClient = this.clientFactory.getClient(input.clusterUrl());
        DeployUnitClient api = new DeployUnitClient(apiClient);
        Path path = input.path();
        if (Files.notExists(path, new LinkOption[0])) {
            return CompletableFuture.completedFuture(DefaultCallOutput.failure(new FileNotFoundException(path.toString())));
        }
        try (Stream<Path> stream = Files.walk(path, 1, new FileVisitOption[0]);){
            files = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).collect(Collectors.toList());
        }
        catch (IOException e) {
            return CompletableFuture.completedFuture(DefaultCallOutput.failure(e));
        }
        TrackingCallback<Boolean> callback = new TrackingCallback<Boolean>(this.tracker);
        String ver = input.version() == null ? "" : input.version();
        DeployMode deployMode = DeployUnitCall.inferDeployMode(input.nodes());
        List<String> initialNodes = deployMode == null ? input.nodes() : null;
        Call call = api.deployUnitAsync(input.id(), files, ver, deployMode, initialNodes, callback);
        return CompletableFuture.supplyAsync(() -> {
            try {
                callback.awaitDone();
            }
            catch (InterruptedException e) {
                return DefaultCallOutput.failure(e);
            }
            if (call.isCanceled()) {
                return DefaultCallOutput.failure(new RuntimeException("Unit deployment process was canceled"));
            }
            if (callback.exception() != null) {
                return DeployUnitCall.handleException(callback.exception(), input);
            }
            return DefaultCallOutput.success(MessageUiComponent.from(UiElements.done()).render());
        });
    }

    private static CallOutput<String> handleException(Exception exception, DeployUnitCallInput input) {
        ApiException apiException;
        if (exception instanceof ApiException && (apiException = (ApiException)exception).getCode() == 409) {
            if (apiException.getResponseBody().contains("Cluster is not initialized")) {
                return DefaultCallOutput.failure(new IgniteCliApiException(exception, input.clusterUrl()));
            }
            return DefaultCallOutput.failure(new UnitAlreadyExistsException(input.id(), input.version()));
        }
        return DefaultCallOutput.failure(new IgniteCliApiException(exception, input.clusterUrl()));
    }

    @Nullable
    private static DeployMode inferDeployMode(List<String> params) {
        if (params == null) {
            return DeployMode.MAJORITY;
        }
        if (params.size() == 1) {
            try {
                return DeployMode.fromValue(params.get(0));
            }
            catch (IllegalArgumentException ignored) {
                return null;
            }
        }
        return null;
    }
}

