/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.metrics;

import java.util.List;
import java.util.function.Consumer;
import org.apache.ignite.internal.metrics.AbstractMetricSource;
import org.apache.ignite.internal.metrics.AtomicLongMetric;
import org.apache.ignite.internal.metrics.Metric;

public class SqlQueryMetricSource
extends AbstractMetricSource<Holder> {
    public static final String NAME = "sql.queries";
    public static final String SUCCESSFUL_QUERIES = "Succeeded";
    public static final String FAILED_QUERIES = "Failed";
    public static final String CANCELED_QUERIES = "Canceled";
    public static final String TIMED_OUT_QUERIES = "TimedOut";

    public SqlQueryMetricSource() {
        super(NAME);
    }

    public void success() {
        this.increment(h -> h.success.increment());
    }

    public void failure() {
        this.increment(h -> h.failure.increment());
    }

    public void timedOut() {
        this.increment(h -> h.timedOut.increment());
    }

    public void cancel() {
        this.increment(h -> h.cancelled.increment());
    }

    private void increment(Consumer<Holder> inc) {
        Holder holder = (Holder)this.holder();
        if (holder != null) {
            inc.accept(holder);
        }
    }

    protected Holder createHolder() {
        return new Holder();
    }

    protected static class Holder
    implements AbstractMetricSource.Holder<Holder> {
        private final AtomicLongMetric success = new AtomicLongMetric("Succeeded", "Successfully completed queries");
        private final AtomicLongMetric failure = new AtomicLongMetric("Failed", "Failed queries");
        private final AtomicLongMetric cancelled = new AtomicLongMetric("Canceled", "Cancelled queries");
        private final AtomicLongMetric timedOut = new AtomicLongMetric("TimedOut", "Timed out queries");

        protected Holder() {
        }

        public Iterable<Metric> metrics() {
            return List.of(this.success, this.failure, this.cancelled, this.timedOut);
        }
    }
}

