/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.events.StoppingIndexEventParameters;
import org.apache.ignite.internal.catalog.storage.AbstractChangeIndexStatusEntry;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.tostring.S;

public class DropIndexEntry
extends AbstractChangeIndexStatusEntry
implements Fireable {
    public DropIndexEntry(int indexId) {
        super(indexId, CatalogIndexStatus.STOPPING);
    }

    public int indexId() {
        return this.indexId;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DROP_INDEX.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.INDEX_STOPPING;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new StoppingIndexEventParameters(causalityToken, catalogVersion, this.indexId);
    }

    @Override
    public String toString() {
        return S.toString(DropIndexEntry.class, (Object)this, (String)super.toString());
    }
}

