/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.mapping;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.partitiondistribution.TokenizedAssignments;
import org.apache.ignite.internal.placementdriver.event.PrimaryReplicaEventParameters;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.sql.engine.exec.mapping.ColocationGroup;
import org.apache.ignite.internal.sql.engine.exec.mapping.ExecutionDistributionProvider;
import org.apache.ignite.internal.sql.engine.exec.mapping.ExecutionTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.ExecutionTargetFactory;
import org.apache.ignite.internal.sql.engine.exec.mapping.FragmentMapper;
import org.apache.ignite.internal.sql.engine.exec.mapping.FragmentMapping;
import org.apache.ignite.internal.sql.engine.exec.mapping.IdGenerator;
import org.apache.ignite.internal.sql.engine.exec.mapping.MappedFragment;
import org.apache.ignite.internal.sql.engine.exec.mapping.MappingContext;
import org.apache.ignite.internal.sql.engine.exec.mapping.MappingParameters;
import org.apache.ignite.internal.sql.engine.exec.mapping.MappingService;
import org.apache.ignite.internal.sql.engine.exec.mapping.QuerySplitter;
import org.apache.ignite.internal.sql.engine.prepare.Fragment;
import org.apache.ignite.internal.sql.engine.prepare.MultiStepPlan;
import org.apache.ignite.internal.sql.engine.prepare.PlanId;
import org.apache.ignite.internal.sql.engine.prepare.pruning.PartitionPruner;
import org.apache.ignite.internal.sql.engine.rel.IgniteReceiver;
import org.apache.ignite.internal.sql.engine.rel.IgniteSender;
import org.apache.ignite.internal.sql.engine.schema.IgniteDataSource;
import org.apache.ignite.internal.sql.engine.schema.IgniteSystemView;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.cache.Cache;
import org.apache.ignite.internal.sql.engine.util.cache.CacheFactory;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.SqlException;
import org.jetbrains.annotations.Nullable;

public class MappingServiceImpl
implements MappingService {
    private final String localNodeName;
    private final ClockService clock;
    private final Cache<PlanId, FragmentsTemplate> templatesCache;
    private final Cache<MappingsCacheKey, MappingsCacheValue> mappingsCache;
    private final PartitionPruner partitionPruner;
    private final Supplier<Long> logicalTopologyVerSupplier;
    private final ExecutionDistributionProvider distributionProvider;

    public MappingServiceImpl(String localNodeName, ClockService clock, CacheFactory cacheFactory, int cacheSize, PartitionPruner partitionPruner, Supplier<Long> logicalTopologyVerSupplier, ExecutionDistributionProvider distributionProvider) {
        this.localNodeName = localNodeName;
        this.clock = clock;
        this.templatesCache = cacheFactory.create(cacheSize);
        this.mappingsCache = cacheFactory.create(cacheSize);
        this.partitionPruner = partitionPruner;
        this.logicalTopologyVerSupplier = logicalTopologyVerSupplier;
        this.distributionProvider = distributionProvider;
    }

    public CompletableFuture<Boolean> onPrimaryReplicaExpired(PrimaryReplicaEventParameters parameters) {
        assert (parameters != null);
        assert (parameters.groupId() instanceof TablePartitionId);
        int tabId = ((TablePartitionId)parameters.groupId()).tableId();
        this.mappingsCache.removeIfValue(value -> value.tableIds.contains(tabId));
        return CompletableFutures.falseCompletedFuture();
    }

    @Override
    public CompletableFuture<List<MappedFragment>> map(MultiStepPlan multiStepPlan, MappingParameters parameters) {
        FragmentsTemplate template = this.getOrCreateTemplate(multiStepPlan);
        boolean mapOnBackups = parameters.mapOnBackups();
        Predicate<String> nodeExclusionFilter = parameters.nodeExclusionFilter();
        CompletableFuture<MappedFragments> mappedFragments = nodeExclusionFilter != null ? this.mapFragments(template, mapOnBackups, nodeExclusionFilter) : this.mappingsCache.compute((MappingsCacheKey)new MappingsCacheKey((PlanId)multiStepPlan.id(), (boolean)mapOnBackups), (BiFunction<MappingsCacheKey, MappingsCacheValue, MappingsCacheValue>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$map$1(org.apache.ignite.internal.sql.engine.exec.mapping.MappingServiceImpl$FragmentsTemplate java.util.function.Predicate boolean org.apache.ignite.internal.sql.engine.exec.mapping.MappingServiceImpl$MappingsCacheKey org.apache.ignite.internal.sql.engine.exec.mapping.MappingServiceImpl$MappingsCacheValue ), (Lorg/apache/ignite/internal/sql/engine/exec/mapping/MappingServiceImpl$MappingsCacheKey;Lorg/apache/ignite/internal/sql/engine/exec/mapping/MappingServiceImpl$MappingsCacheValue;)Lorg/apache/ignite/internal/sql/engine/exec/mapping/MappingServiceImpl$MappingsCacheValue;)((MappingServiceImpl)this, (FragmentsTemplate)template, nodeExclusionFilter, (boolean)mapOnBackups)).mappedFragments;
        return mappedFragments.thenApply(frags -> this.applyPartitionPruning(frags.fragments, parameters));
    }

    CompletableFuture<DistributionHolder> composeDistributions(Set<IgniteSystemView> views, Set<IgniteTable> tables, boolean mapOnBackups) {
        if (tables.isEmpty() && views.isEmpty()) {
            DistributionHolder holder = new DistributionHolder(Set.of(this.localNodeName), (Int2ObjectMap<List<TokenizedAssignments>>)Int2ObjectMaps.emptyMap(), (Int2ObjectMap<List<String>>)Int2ObjectMaps.emptyMap());
            return CompletableFuture.completedFuture(holder);
        }
        Int2ObjectOpenHashMap tablesAssignments = new Int2ObjectOpenHashMap(tables.size());
        HashSet<String> allNodes = new HashSet<String>();
        allNodes.add(this.localNodeName);
        for (IgniteTable tbl : tables) {
            CompletableFuture<List<TokenizedAssignments>> assignments = this.distributionProvider.forTable(this.clock.now(), tbl, mapOnBackups);
            tablesAssignments.put(tbl.id(), assignments);
        }
        return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])tablesAssignments.values().toArray((Object[])new CompletableFuture[0])).thenApply(arg_0 -> MappingServiceImpl.lambda$composeDistributions$5(tables, (Int2ObjectMap)tablesAssignments, allNodes, arg_0))).thenApply(assignmentsPerTable -> {
            Int2ObjectMap nodesPerView = (Int2ObjectMap)views.stream().collect(CollectionUtils.toIntMapCollector(IgniteDataSource::id, this.distributionProvider::forSystemView));
            nodesPerView.values().stream().flatMap(Collection::stream).forEach(allNodes::add);
            return new DistributionHolder(allNodes, (Int2ObjectMap<List<TokenizedAssignments>>)assignmentsPerTable, (Int2ObjectMap<List<String>>)nodesPerView);
        });
    }

    private CompletableFuture<MappedFragments> mapFragments(FragmentsTemplate template, boolean mapOnBackups, @Nullable Predicate<String> nodeExclusionFilter) {
        Set<IgniteSystemView> views = template.fragments.stream().flatMap(fragment -> fragment.systemViews().stream()).collect(Collectors.toSet());
        Set<IgniteTable> tables = template.fragments.stream().flatMap(fragment -> fragment.tables().values().stream()).collect(Collectors.toSet());
        CompletableFuture<DistributionHolder> res = this.composeDistributions(views, tables, mapOnBackups);
        return res.thenApply(assignments -> {
            Int2ObjectOpenHashMap targetsById = new Int2ObjectOpenHashMap();
            MappingContext context = new MappingContext(this.localNodeName, assignments.nodes(nodeExclusionFilter), template.cluster);
            ExecutionTargetFactory targetFactory = context.targetFactory();
            List<IntObjectPair<ExecutionTarget>> allTargets = MappingServiceImpl.prepareTargets(template, assignments, targetFactory);
            for (IntObjectPair<ExecutionTarget> pair : allTargets) {
                targetsById.put(pair.firstInt(), (Object)((ExecutionTarget)pair.second()));
            }
            FragmentMapper mapper = new FragmentMapper(context.cluster().getMetadataQuery(), context, (Int2ObjectMap<ExecutionTarget>)targetsById);
            IdGenerator idGenerator = new IdGenerator(template.nextId);
            ArrayList<Fragment> fragments = new ArrayList<Fragment>(template.fragments);
            List<FragmentMapping> mappings = mapper.map(fragments, idGenerator);
            Long2ObjectOpenHashMap groupsBySourceId = new Long2ObjectOpenHashMap();
            Long2ObjectOpenHashMap allSourcesByExchangeId = new Long2ObjectOpenHashMap();
            for (FragmentMapping mapping : mappings) {
                Fragment fragment = mapping.fragment();
                for (ColocationGroup group : mapping.groups()) {
                    for (long sourceId : group.sourceIds()) {
                        groupsBySourceId.put(sourceId, (Object)group);
                    }
                }
                if (fragment.rootFragment()) continue;
                IgniteSender sender = (IgniteSender)fragment.root();
                List nodeNames = mapping.groups().stream().flatMap(g -> g.nodeNames().stream()).distinct().collect(Collectors.toList());
                allSourcesByExchangeId.put(sender.exchangeId(), nodeNames);
            }
            ArrayList<MappedFragment> mappedFragmentsList = new ArrayList<MappedFragment>(mappings.size());
            HashSet<String> targetNodes = new HashSet<String>();
            for (FragmentMapping mapping : mappings) {
                Fragment fragment = mapping.fragment();
                ColocationGroup targetGroup = null;
                if (!fragment.rootFragment()) {
                    IgniteSender sender = (IgniteSender)fragment.root();
                    targetGroup = (ColocationGroup)groupsBySourceId.get(sender.exchangeId());
                }
                Long2ObjectOpenHashMap sourcesByExchangeId = null;
                for (IgniteReceiver receiver : fragment.remotes()) {
                    if (sourcesByExchangeId == null) {
                        sourcesByExchangeId = new Long2ObjectOpenHashMap();
                    }
                    long exchangeId = receiver.exchangeId();
                    sourcesByExchangeId.put(exchangeId, (Object)((List)allSourcesByExchangeId.get(exchangeId)));
                }
                MappedFragment mappedFragment = new MappedFragment(fragment, mapping.groups(), (Long2ObjectMap<List<String>>)sourcesByExchangeId, targetGroup, null);
                mappedFragmentsList.add(mappedFragment);
                targetNodes.addAll(mappedFragment.nodes());
            }
            return new MappedFragments(mappedFragmentsList, targetNodes);
        });
    }

    private static List<IntObjectPair<ExecutionTarget>> prepareTargets(FragmentsTemplate template, DistributionHolder distr, ExecutionTargetFactory targetFactory) {
        Stream tableTargets = template.fragments.stream().flatMap(fragment -> fragment.tables().values().stream().map(table -> IntObjectPair.of((int)table.id(), (Object)MappingServiceImpl.buildTargetforTable(targetFactory, distr.tableAssignments(table.id())))));
        Stream viewTargets = template.fragments.stream().flatMap(fragment -> fragment.systemViews().stream().map(view -> IntObjectPair.of((int)view.id(), (Object)MappingServiceImpl.buildTargetForSystemView(targetFactory, view, distr.viewNodes(view.id())))));
        return Stream.concat(tableTargets, viewTargets).collect(Collectors.toList());
    }

    private static ExecutionTarget buildTargetForSystemView(ExecutionTargetFactory factory, IgniteSystemView view, List<String> nodes) {
        if (CollectionUtils.nullOrEmpty(nodes)) {
            throw new SqlException(ErrorGroups.Sql.MAPPING_ERR, IgniteStringFormatter.format((String)"The view with name '{}' could not be found on any active nodes in the cluster", (Object[])new Object[]{view.name()}));
        }
        return view.distribution() == IgniteDistributions.single() ? factory.oneOf(nodes) : factory.allOf(nodes);
    }

    private static ExecutionTarget buildTargetforTable(ExecutionTargetFactory factory, List<TokenizedAssignments> assignments) {
        return factory.partitioned(assignments);
    }

    private List<MappedFragment> applyPartitionPruning(List<MappedFragment> mappedFragments, MappingParameters parameters) {
        return this.partitionPruner.apply(mappedFragments, parameters.dynamicParameters());
    }

    private FragmentsTemplate getOrCreateTemplate(MultiStepPlan plan) {
        return this.templatesCache.get(plan.id(), key -> {
            IdGenerator idGenerator = new IdGenerator(0L);
            RelOptCluster cluster = Commons.cluster();
            List<Fragment> fragments = new QuerySplitter(idGenerator, cluster).split(plan.root());
            return new FragmentsTemplate(idGenerator.nextId(), cluster, fragments);
        });
    }

    private static /* synthetic */ Int2ObjectMap lambda$composeDistributions$5(Set tables, Int2ObjectMap tablesAssignments, Set allNodes, Void ignore) {
        Int2ObjectOpenHashMap assignmentsPerTable = new Int2ObjectOpenHashMap(tables.size());
        tablesAssignments.keySet().forEach(arg_0 -> MappingServiceImpl.lambda$composeDistributions$4(tablesAssignments, allNodes, (Int2ObjectMap)assignmentsPerTable, arg_0));
        return assignmentsPerTable;
    }

    private static /* synthetic */ void lambda$composeDistributions$4(Int2ObjectMap tablesAssignments, Set allNodes, Int2ObjectMap assignmentsPerTable, int k) {
        List assignments = (List)((CompletableFuture)tablesAssignments.get(k)).join();
        assignments.stream().flatMap(i -> i.nodes().stream()).map(Assignment::consistentId).forEach(allNodes::add);
        assignmentsPerTable.put(k, (Object)assignments);
    }

    private /* synthetic */ MappingsCacheValue lambda$map$1(FragmentsTemplate template, Predicate nodeExclusionFilter, boolean mapOnBackups, MappingsCacheKey key, MappingsCacheValue val) {
        if (val == null) {
            long topVer;
            IntOpenHashSet tableIds = new IntOpenHashSet();
            boolean topologyAware = false;
            for (Fragment fragment : template.fragments) {
                topologyAware = topologyAware || !fragment.systemViews().isEmpty();
                for (IgniteDataSource source : fragment.tables().values()) {
                    tableIds.add(source.id());
                }
            }
            long l = topVer = topologyAware ? this.logicalTopologyVerSupplier.get() : Long.MAX_VALUE;
            assert (nodeExclusionFilter == null);
            return new MappingsCacheValue(topVer, (IntSet)tableIds, this.mapFragments(template, mapOnBackups, null));
        }
        long topologyVer = this.logicalTopologyVerSupplier.get();
        if (val.topologyVersion < topologyVer) {
            return new MappingsCacheValue(topologyVer, val.tableIds, this.mapFragments(template, mapOnBackups, null));
        }
        return val;
    }

    private static class FragmentsTemplate {
        private final long nextId;
        private final RelOptCluster cluster;
        private final List<Fragment> fragments;

        FragmentsTemplate(long nextId, RelOptCluster cluster, List<Fragment> fragments) {
            this.nextId = nextId;
            this.cluster = cluster;
            this.fragments = fragments;
        }
    }

    private static class MappingsCacheKey {
        private final PlanId planId;
        private final boolean mapOnBackups;

        MappingsCacheKey(PlanId planId, boolean mapOnBackups) {
            this.planId = planId;
            this.mapOnBackups = mapOnBackups;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MappingsCacheKey that = (MappingsCacheKey)o;
            return this.mapOnBackups == that.mapOnBackups && Objects.equals(this.planId, that.planId);
        }

        public int hashCode() {
            return Objects.hash(this.planId, this.mapOnBackups);
        }
    }

    private static class MappingsCacheValue {
        private final long topologyVersion;
        private final IntSet tableIds;
        private final CompletableFuture<MappedFragments> mappedFragments;

        MappingsCacheValue(long topologyVersion, IntSet tableIds, CompletableFuture<MappedFragments> mappedFragments) {
            this.topologyVersion = topologyVersion;
            this.tableIds = tableIds;
            this.mappedFragments = mappedFragments;
        }
    }

    private static class DistributionHolder {
        private final Set<String> nodes;
        private final Int2ObjectMap<List<TokenizedAssignments>> assignmentsPerTable;
        private final Int2ObjectMap<List<String>> nodesPerView;

        DistributionHolder(Set<String> nodes, Int2ObjectMap<List<TokenizedAssignments>> assignmentsPerTable, Int2ObjectMap<List<String>> nodesPerView) {
            this.nodes = nodes;
            this.assignmentsPerTable = assignmentsPerTable;
            this.nodesPerView = nodesPerView;
        }

        List<String> nodes(@Nullable Predicate<String> nodeExclusionFilter) {
            if (nodeExclusionFilter == null) {
                return List.copyOf(this.nodes);
            }
            return this.nodes.stream().filter(nodeExclusionFilter.negate()).collect(Collectors.toList());
        }

        List<TokenizedAssignments> tableAssignments(int tableId) {
            return (List)this.assignmentsPerTable.get(tableId);
        }

        List<String> viewNodes(int viewId) {
            return (List)this.nodesPerView.get(viewId);
        }
    }

    private static class MappedFragments {
        final List<MappedFragment> fragments;
        final Set<String> nodes;

        MappedFragments(List<MappedFragment> fragments, Set<String> nodes) {
            this.fragments = fragments;
            this.nodes = nodes;
        }
    }
}

