/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactor.http.client.websocket;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.reactor.http.client.websocket.ReactorWebSocketClient;
import io.micronaut.websocket.WebSocketClient;
import java.net.URI;
import java.util.Map;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Internal
class BridgedReactorWebSocketClient
implements ReactorWebSocketClient {
    private final WebSocketClient webSocketClient;

    BridgedReactorWebSocketClient(WebSocketClient webSocketClient) {
        this.webSocketClient = webSocketClient;
    }

    @Override
    public <T extends AutoCloseable> Flux<T> connect(Class<T> clientEndpointType, MutableHttpRequest<?> request) {
        return Flux.from((Publisher)this.webSocketClient.connect(clientEndpointType, request));
    }

    @Override
    public <T extends AutoCloseable> Flux<T> connect(Class<T> clientEndpointType, URI uri) {
        return Flux.from((Publisher)this.webSocketClient.connect(clientEndpointType, uri));
    }

    @Override
    public <T extends AutoCloseable> Flux<T> connect(Class<T> clientEndpointType, Map<String, Object> parameters) {
        return Flux.from((Publisher)this.webSocketClient.connect(clientEndpointType, parameters));
    }

    @Override
    public <T extends AutoCloseable> Flux<T> connect(Class<T> clientEndpointType, String uri) {
        return Flux.from((Publisher)this.webSocketClient.connect(clientEndpointType, uri));
    }

    public void close() {
        this.webSocketClient.close();
    }
}

