/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.distributionzones.rebalance;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.distributionzones.rebalance.RebalanceMinimumRequiredTimeProvider;
import org.apache.ignite.internal.distributionzones.rebalance.RebalanceUtil;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.Cursor;

public class RebalanceMinimumRequiredTimeProviderImpl
implements RebalanceMinimumRequiredTimeProvider {
    private final MetaStorageManager metaStorageManager;
    private final CatalogService catalogService;

    public RebalanceMinimumRequiredTimeProviderImpl(MetaStorageManager metaStorageManager, CatalogService catalogService) {
        this.metaStorageManager = metaStorageManager;
        this.catalogService = catalogService;
    }

    @Override
    public long minimumRequiredTime() {
        long metaStorageSafeTime;
        long appliedRevision = this.metaStorageManager.appliedRevision();
        long minTimestamp = metaStorageSafeTime = this.metaStorageManager.timestampByRevisionLocally(appliedRevision).longValue();
        Map<Integer, Map<Integer, Assignments>> stableAssignments = this.readAssignments(RebalanceUtil.STABLE_ASSIGNMENTS_PREFIX_BYTES, appliedRevision);
        Map<Integer, Map<Integer, Assignments>> pendingAssignments = this.readAssignments(RebalanceUtil.PENDING_ASSIGNMENTS_PREFIX_BYTES, appliedRevision);
        Map<Integer, Long> pendingChangeTriggerRevisions = this.readPendingChangeTriggerRevisions(RebalanceUtil.PENDING_CHANGE_TRIGGER_PREFIX_BYTES, appliedRevision);
        int earliestCatalogVersion = this.catalogService.earliestCatalogVersion();
        int latestCatalogVersion = this.catalogService.latestCatalogVersion();
        Map<Integer, Integer> tableIdToZoneIdMap = this.tableIdToZoneIdMap(earliestCatalogVersion, latestCatalogVersion);
        HashMap<Long, Long> updateTokensToActivationTimeMap = new HashMap<Long, Long>();
        Map<Integer, NavigableMap<Long, CatalogZoneDescriptor>> allZonesByTimestamp = this.allZonesByTimestamp(earliestCatalogVersion, latestCatalogVersion, updateTokensToActivationTimeMap);
        Map<Integer, NavigableMap<Long, CatalogZoneDescriptor>> allZonesByRevision = RebalanceMinimumRequiredTimeProviderImpl.allZonesByRevision(allZonesByTimestamp);
        Map<Integer, Long> zoneDeletionTimestamps = this.zoneDeletionTimestamps(earliestCatalogVersion, latestCatalogVersion);
        for (Map.Entry<Integer, Integer> entry : tableIdToZoneIdMap.entrySet()) {
            Integer tableId = entry.getKey();
            Integer zoneId = entry.getValue();
            NavigableMap<Long, CatalogZoneDescriptor> zoneDescriptors = allZonesByTimestamp.get(zoneId);
            int zonePartitions = zoneDescriptors.lastEntry().getValue().partitions();
            Long pendingChangeTriggerRevision = pendingChangeTriggerRevisions.get(tableId);
            long latestTimestamp = zoneDeletionTimestamps.getOrDefault(zoneId, metaStorageSafeTime + 1L) - 1L;
            long zoneRevision = pendingChangeTriggerRevision == null ? zoneDescriptors.firstEntry().getValue().updateToken() : pendingChangeTriggerRevision.longValue();
            NavigableMap<Long, CatalogZoneDescriptor> map = allZonesByRevision.get(zoneId);
            Map.Entry<Long, CatalogZoneDescriptor> zone = map.floorEntry(zoneRevision);
            long timestamp = (Long)updateTokensToActivationTimeMap.get(zone.getValue().updateToken());
            timestamp = RebalanceMinimumRequiredTimeProviderImpl.ceilTime(zoneDescriptors, timestamp, latestTimestamp);
            minTimestamp = Math.min(minTimestamp, timestamp);
            Map<Integer, Assignments> pendingTableAssignments = pendingAssignments.getOrDefault(tableId, Collections.emptyMap());
            if (pendingTableAssignments.isEmpty()) continue;
            long pendingTimestamp = RebalanceMinimumRequiredTimeProviderImpl.findProperTimestampForAssignments(pendingTableAssignments.size() == zonePartitions ? pendingTableAssignments : stableAssignments.getOrDefault(tableId, Collections.emptyMap()), zoneDescriptors, latestTimestamp);
            minTimestamp = Math.min(minTimestamp, pendingTimestamp);
        }
        return minTimestamp;
    }

    static Map<Integer, NavigableMap<Long, CatalogZoneDescriptor>> allZonesByRevision(Map<Integer, NavigableMap<Long, CatalogZoneDescriptor>> allZones) {
        return allZones.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            TreeMap<Long, CatalogZoneDescriptor> mapByRevision = new TreeMap<Long, CatalogZoneDescriptor>();
            for (CatalogZoneDescriptor zone : ((NavigableMap)entry.getValue()).values()) {
                mapByRevision.put(zone.updateToken(), zone);
            }
            return mapByRevision;
        }));
    }

    Map<Integer, NavigableMap<Long, CatalogZoneDescriptor>> allZonesByTimestamp(int earliestCatalogVersion, int latestCatalogVersion, Map<Long, Long> updateTokensToActivationTime) {
        HashMap<Integer, NavigableMap<Long, CatalogZoneDescriptor>> allZones = new HashMap<Integer, NavigableMap<Long, CatalogZoneDescriptor>>();
        for (int catalogVersion = earliestCatalogVersion; catalogVersion <= latestCatalogVersion; ++catalogVersion) {
            Catalog catalog = this.catalogService.catalog(catalogVersion);
            for (CatalogZoneDescriptor zone : catalog.zones()) {
                NavigableMap map = allZones.computeIfAbsent(zone.id(), id -> new TreeMap());
                if (!map.isEmpty() && !CatalogZoneDescriptor.updateRequiresAssignmentsRecalculation((CatalogZoneDescriptor)((CatalogZoneDescriptor)map.lastEntry().getValue()), (CatalogZoneDescriptor)zone)) continue;
                map.put(catalog.time(), zone);
                updateTokensToActivationTime.put(zone.updateToken(), catalog.time());
            }
        }
        return allZones;
    }

    Map<Integer, Long> zoneDeletionTimestamps(int earliestCatalogVersion, int latestCatalogVersion) {
        HashSet<Integer> existingZoneIds = new HashSet<Integer>();
        HashMap<Integer, Long> zoneDeletionTimestamps = new HashMap<Integer, Long>();
        for (int catalogVersion = earliestCatalogVersion; catalogVersion <= latestCatalogVersion; ++catalogVersion) {
            Catalog catalog = this.catalogService.catalog(catalogVersion);
            Iterator iterator = existingZoneIds.iterator();
            while (iterator.hasNext()) {
                Integer zoneId = (Integer)iterator.next();
                if (catalog.zone(zoneId.intValue()) != null) continue;
                zoneDeletionTimestamps.put(zoneId, catalog.time());
                iterator.remove();
            }
            for (CatalogZoneDescriptor zone : catalog.zones()) {
                existingZoneIds.add(zone.id());
            }
        }
        return zoneDeletionTimestamps;
    }

    static long ceilTime(NavigableMap<Long, CatalogZoneDescriptor> zoneDescriptors, long timestamp, long latestTimestamp) {
        Long ceilingKey = zoneDescriptors.ceilingKey(timestamp + 1L);
        return ceilingKey == null ? latestTimestamp : ceilingKey - 1L;
    }

    static long findProperTimestampForAssignments(Map<Integer, Assignments> assignments, NavigableMap<Long, CatalogZoneDescriptor> zoneDescriptors, long latestTimestamp) {
        long timestamp = assignments.values().stream().mapToLong(Assignments::timestamp).max().orElse(zoneDescriptors.firstEntry().getKey());
        return RebalanceMinimumRequiredTimeProviderImpl.ceilTime(zoneDescriptors, timestamp, latestTimestamp);
    }

    private Map<Integer, Integer> tableIdToZoneIdMap(int earliestCatalogVersion, int latestCatalogVersion) {
        HashMap<Integer, Integer> tableIdToZoneIdMap = new HashMap<Integer, Integer>();
        for (int catalogVersion = earliestCatalogVersion; catalogVersion <= latestCatalogVersion; ++catalogVersion) {
            Catalog catalog = this.catalogService.catalog(catalogVersion);
            for (CatalogTableDescriptor table : catalog.tables()) {
                tableIdToZoneIdMap.putIfAbsent(table.id(), table.zoneId());
            }
        }
        return tableIdToZoneIdMap;
    }

    Map<Integer, Map<Integer, Assignments>> readAssignments(byte[] prefix, long appliedRevision) {
        HashMap<Integer, Map<Integer, Assignments>> assignments = new HashMap<Integer, Map<Integer, Assignments>>();
        try (Cursor<Entry> entries = this.readLocallyByPrefix(prefix, appliedRevision);){
            for (Entry entry : entries) {
                if (entry.empty() || entry.tombstone()) continue;
                TablePartitionId tablePartitionId = RebalanceUtil.extractTablePartitionId(entry.key(), prefix);
                int tableId = tablePartitionId.tableId();
                int partitionId = tablePartitionId.partitionId();
                assignments.computeIfAbsent(tableId, id -> new HashMap()).put(partitionId, Assignments.fromBytes((byte[])entry.value()));
            }
        }
        return assignments;
    }

    Map<Integer, Long> readPendingChangeTriggerRevisions(byte[] prefix, long appliedRevision) {
        HashMap<Integer, Long> revisions = new HashMap<Integer, Long>();
        try (Cursor<Entry> entries = this.readLocallyByPrefix(prefix, appliedRevision);){
            for (Entry entry : entries) {
                if (entry.empty() || entry.tombstone()) continue;
                int tableId = RebalanceUtil.extractTablePartitionId(entry.key(), prefix).tableId();
                byte[] value = entry.value();
                long revision = ByteUtils.bytesToLongKeepingOrder((byte[])value);
                revisions.compute(tableId, (k, prev) -> prev == null ? revision : Math.min(prev, revision));
            }
        }
        return revisions;
    }

    private Cursor<Entry> readLocallyByPrefix(byte[] prefix, long revision) {
        return this.metaStorageManager.prefixLocally(new ByteArray(prefix), revision);
    }
}

