/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.EventExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.network.configuration.InboundView;
import org.apache.ignite.internal.network.configuration.NetworkConfiguration;
import org.apache.ignite.internal.network.configuration.NetworkView;
import org.apache.ignite.internal.network.configuration.OutboundView;
import org.apache.ignite.internal.network.netty.ChannelEventLoopsSource;
import org.apache.ignite.internal.network.netty.NamedNioEventLoopGroup;
import org.apache.ignite.internal.util.CompletableFutures;
import org.jetbrains.annotations.TestOnly;

public class NettyBootstrapFactory
implements IgniteComponent,
ChannelEventLoopsSource {
    private final NetworkConfiguration networkConfiguration;
    private final String eventLoopGroupNamePrefix;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private EventLoopGroup clientWorkerGroup;
    private volatile List<EventLoop> channelEventLoops;

    public NettyBootstrapFactory(NetworkConfiguration networkConfiguration, String eventLoopGroupNamePrefix) {
        assert (eventLoopGroupNamePrefix != null);
        assert (networkConfiguration != null);
        this.networkConfiguration = networkConfiguration;
        this.eventLoopGroupNamePrefix = eventLoopGroupNamePrefix;
    }

    public Bootstrap createClientBootstrap() {
        OutboundView clientConfiguration = ((NetworkView)this.networkConfiguration.value()).outbound();
        Bootstrap clientBootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)clientBootstrap.group(this.clientWorkerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)clientConfiguration.soKeepAlive())).option(ChannelOption.SO_LINGER, (Object)clientConfiguration.soLinger())).option(ChannelOption.TCP_NODELAY, (Object)clientConfiguration.tcpNoDelay());
        return clientBootstrap;
    }

    public ServerBootstrap createServerBootstrap() {
        InboundView serverConfiguration = ((NetworkView)this.networkConfiguration.value()).inbound();
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)serverConfiguration.soBacklog())).option(ChannelOption.SO_REUSEADDR, (Object)serverConfiguration.soReuseAddr())).childOption(ChannelOption.SO_KEEPALIVE, (Object)serverConfiguration.soKeepAlive()).childOption(ChannelOption.SO_LINGER, (Object)serverConfiguration.soLinger()).childOption(ChannelOption.TCP_NODELAY, (Object)serverConfiguration.tcpNoDelay());
        return serverBootstrap;
    }

    List<EventLoopGroup> eventLoopGroups() {
        return List.of(this.bossGroup, this.workerGroup, this.clientWorkerGroup);
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.bossGroup = NamedNioEventLoopGroup.create(this.eventLoopGroupNamePrefix + "-srv-accept");
        this.workerGroup = NamedNioEventLoopGroup.create(this.eventLoopGroupNamePrefix + "-srv-worker");
        this.clientWorkerGroup = NamedNioEventLoopGroup.create(this.eventLoopGroupNamePrefix + "-client");
        this.channelEventLoops = List.copyOf(NettyBootstrapFactory.eventLoopsAt(this.workerGroup, this.clientWorkerGroup));
        return CompletableFutures.nullCompletedFuture();
    }

    private static List<EventLoop> eventLoopsAt(EventLoopGroup ... groups) {
        ArrayList<EventLoop> channelEventLoops = new ArrayList<EventLoop>();
        for (EventLoopGroup group : groups) {
            for (EventExecutor child : group) {
                channelEventLoops.add((EventLoop)child);
            }
        }
        return channelEventLoops;
    }

    public static boolean isInNetworkThread() {
        Thread thread = Thread.currentThread();
        return thread instanceof NamedNioEventLoopGroup.NetworkThread;
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        NetworkView configurationView = (NetworkView)this.networkConfiguration.value();
        long quietPeriod = configurationView.shutdownQuietPeriod();
        long shutdownTimeout = configurationView.shutdownTimeout();
        try {
            this.clientWorkerGroup.shutdownGracefully(quietPeriod, shutdownTimeout, TimeUnit.MILLISECONDS).sync();
            this.workerGroup.shutdownGracefully(quietPeriod, shutdownTimeout, TimeUnit.MILLISECONDS).sync();
            this.bossGroup.shutdownGracefully(quietPeriod, shutdownTimeout, TimeUnit.MILLISECONDS).sync();
        }
        catch (InterruptedException e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public List<EventLoop> channelEventLoops() {
        return this.channelEventLoops;
    }

    @TestOnly
    public EventLoopGroup serverEventLoopGroup() {
        return this.workerGroup;
    }
}

