/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.impl;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyEventListener;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.configuration.MetaStorageConfiguration;
import org.apache.ignite.internal.metastorage.impl.ElectionListener;
import org.apache.ignite.internal.metastorage.impl.MetaStorageLearnerManager;
import org.apache.ignite.internal.metastorage.impl.MetaStorageServiceImpl;
import org.apache.ignite.internal.metastorage.server.time.ClusterTimeImpl;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.raft.LeaderElectionListener;
import org.apache.ignite.internal.raft.service.RaftGroupService;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

public class MetaStorageLeaderElectionListener
implements LeaderElectionListener {
    private static final IgniteLogger LOG = Loggers.forClass(MetaStorageLeaderElectionListener.class);
    private final IgniteSpinBusyLock busyLock;
    private final String nodeName;
    private final LogicalTopologyService logicalTopologyService;
    private final CompletableFuture<MetaStorageServiceImpl> metaStorageSvcFut;
    private final MetaStorageLearnerManager learnerManager;
    @Nullable
    private CompletableFuture<Void> serializationFuture = null;
    private final Object serializationFutureMux = new Object();
    private final ClusterTimeImpl clusterTime;
    private final LogicalTopologyEventListener logicalTopologyEventListener = new MetaStorageLogicalTopologyEventListener();
    private final CompletableFuture<MetaStorageConfiguration> metaStorageConfigurationFuture;
    private final List<ElectionListener> electionListeners;
    private final BooleanSupplier leaderSecondaryDutiesPaused;
    @Nullable
    private Long thisNodeTerm = null;

    MetaStorageLeaderElectionListener(IgniteSpinBusyLock busyLock, ClusterService clusterService, LogicalTopologyService logicalTopologyService, CompletableFuture<MetaStorageServiceImpl> metaStorageSvcFut, MetaStorageLearnerManager learnerManager, ClusterTimeImpl clusterTime, CompletableFuture<MetaStorageConfiguration> metaStorageConfigurationFuture, List<ElectionListener> electionListeners, BooleanSupplier leaderSecondaryDutiesPaused) {
        this.busyLock = busyLock;
        this.nodeName = clusterService.nodeName();
        this.logicalTopologyService = logicalTopologyService;
        this.metaStorageSvcFut = metaStorageSvcFut;
        this.learnerManager = learnerManager;
        this.clusterTime = clusterTime;
        this.metaStorageConfigurationFuture = metaStorageConfigurationFuture;
        this.electionListeners = electionListeners;
        this.leaderSecondaryDutiesPaused = leaderSecondaryDutiesPaused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLeaderElected(ClusterNode node, long term) {
        LOG.info("New leader is elected for Metastorage, leader {}, term {}", new Object[]{node, term});
        this.electionListeners.forEach(listener -> listener.onLeaderElected(node));
        boolean weAreNewLeader = node.name().equals(this.nodeName);
        Object object = this.serializationFutureMux;
        synchronized (object) {
            boolean weWerePreviousLeader;
            boolean bl = weWerePreviousLeader = this.serializationFuture != null;
            if (weWerePreviousLeader && !weAreNewLeader) {
                LOG.info("Node has lost the leadership, stopping doing secondary duties", new Object[0]);
                this.thisNodeTerm = null;
                this.clusterTime.stopSafeTimeScheduler();
                this.logicalTopologyService.removeEventListener(this.logicalTopologyEventListener);
                this.serializationFuture.cancel(false);
                this.serializationFuture = null;
            }
            if (weAreNewLeader) {
                this.thisNodeTerm = term;
                if (!weWerePreviousLeader) {
                    LOG.info("Node has been elected as the leader (and it wasn't previous leader), so starting doing secondary duties", new Object[0]);
                    this.startSafeTimeScheduler();
                    this.logicalTopologyService.addEventListener(this.logicalTopologyEventListener);
                    this.serializationFuture = (this.serializationFuture == null ? CompletableFutures.nullCompletedFuture() : this.serializationFuture).thenCompose(unused -> this.updateLearnersIfSecondaryDutiesAreNotPaused(term));
                } else {
                    LOG.info("Node has been reelected as the leader", new Object[0]);
                }
            }
        }
    }

    private void startSafeTimeScheduler() {
        ((CompletableFuture)this.metaStorageSvcFut.thenAcceptBoth(this.metaStorageConfigurationFuture, (service, metaStorageConfiguration) -> this.clusterTime.startSafeTimeScheduler(safeTime -> this.syncTimeIfSecondaryDutiesAreNotPaused(safeTime, (MetaStorageServiceImpl)service), (MetaStorageConfiguration)metaStorageConfiguration))).whenComplete((v, e) -> {
            if (e != null) {
                LOG.error("Unable to start Idle Safe Time scheduler", e);
            }
        });
    }

    private CompletableFuture<Void> updateLearnersIfSecondaryDutiesAreNotPaused(long term) {
        if (this.leaderSecondaryDutiesPaused.getAsBoolean()) {
            LOG.info("Skipping learners update as secondary duties are still paused", new Object[0]);
            return CompletableFutures.nullCompletedFuture();
        }
        LOG.info("Actually updating learners with term {}", new Object[]{term});
        return this.learnerManager.updateLearners(term);
    }

    private CompletableFuture<Void> syncTimeIfSecondaryDutiesAreNotPaused(HybridTimestamp safeTime, MetaStorageServiceImpl service) {
        if (this.leaderSecondaryDutiesPaused.getAsBoolean()) {
            return CompletableFutures.nullCompletedFuture();
        }
        Long term = this.thisNodeTerm;
        if (term == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        return service.syncTime(safeTime, term);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Action action) {
        if (!this.busyLock.enterBusy()) {
            LOG.info("Skipping Meta Storage configuration update because the node is stopping", new Object[0]);
            return;
        }
        try {
            if (this.leaderSecondaryDutiesPaused.getAsBoolean()) {
                LOG.info("Skipping Meta Storage configuration update because the leader's secondary duties are paused", new Object[0]);
                return;
            }
            Object object = this.serializationFutureMux;
            synchronized (object) {
                block12: {
                    if (this.serializationFuture != null) break block12;
                    return;
                }
                assert (this.thisNodeTerm != null);
                long term = this.thisNodeTerm;
                this.serializationFuture = ((CompletableFuture)this.serializationFuture.handle((v, e) -> this.metaStorageSvcFut.thenCompose(service -> action.apply(service.raftGroupService(), term)))).thenCompose(Function.identity());
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private class MetaStorageLogicalTopologyEventListener
    implements LogicalTopologyEventListener {
        private MetaStorageLogicalTopologyEventListener() {
        }

        public void onNodeValidated(LogicalNode validatedNode) {
            MetaStorageLeaderElectionListener.this.execute((raftService, term) -> MetaStorageLeaderElectionListener.this.learnerManager.addLearner(raftService, (ClusterNode)validatedNode));
        }

        public void onNodeInvalidated(LogicalNode invalidatedNode) {
            MetaStorageLeaderElectionListener.this.execute((raftService, term) -> MetaStorageLeaderElectionListener.this.learnerManager.removeLearner(raftService, (ClusterNode)invalidatedNode));
        }

        public void onNodeLeft(LogicalNode leftNode, LogicalTopologySnapshot newTopology) {
            this.onNodeInvalidated(leftNode);
        }

        public void onTopologyLeap(LogicalTopologySnapshot newTopology) {
            MetaStorageLeaderElectionListener.this.execute(MetaStorageLeaderElectionListener.this.learnerManager::resetLearners);
        }
    }

    @FunctionalInterface
    private static interface Action {
        public CompletableFuture<Void> apply(RaftGroupService var1, long var2);
    }
}

