/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery.message;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartResponseMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartResponseMessageBuilder;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class HandshakeStartResponseMessageImpl
implements HandshakeStartResponseMessage {
    public static final short GROUP_TYPE = 1;
    public static final short TYPE = 4;
    @IgniteToStringInclude
    private final short connectionId;
    @IgniteToStringInclude
    private final String consistentId;
    @IgniteToStringInclude
    private final UUID launchId;
    @IgniteToStringInclude
    private final long receivedCount;

    private HandshakeStartResponseMessageImpl(short connectionId, String consistentId, UUID launchId, long receivedCount) {
        this.connectionId = connectionId;
        this.consistentId = consistentId;
        this.launchId = launchId;
        this.receivedCount = receivedCount;
    }

    @Override
    public short connectionId() {
        return this.connectionId;
    }

    @Override
    public String consistentId() {
        return this.consistentId;
    }

    @Override
    public UUID launchId() {
        return this.launchId;
    }

    @Override
    public long receivedCount() {
        return this.receivedCount;
    }

    public short groupType() {
        return 1;
    }

    public String toString() {
        return S.toString(HandshakeStartResponseMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 4;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HandshakeStartResponseMessageImpl otherMessage = (HandshakeStartResponseMessageImpl)other;
        return Objects.equals(this.consistentId, otherMessage.consistentId) && Objects.equals(this.launchId, otherMessage.launchId) && this.connectionId == otherMessage.connectionId && this.receivedCount == otherMessage.receivedCount;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.connectionId, this.receivedCount, this.consistentId, this.launchId);
        return result;
    }

    public static HandshakeStartResponseMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements HandshakeStartResponseMessageBuilder {
        private short connectionId;
        private String consistentId;
        private UUID launchId;
        private long receivedCount;

        private Builder() {
        }

        @Override
        public HandshakeStartResponseMessageBuilder connectionId(short connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        @Override
        public HandshakeStartResponseMessageBuilder consistentId(String consistentId) {
            this.consistentId = consistentId;
            return this;
        }

        @Override
        public HandshakeStartResponseMessageBuilder launchId(UUID launchId) {
            this.launchId = launchId;
            return this;
        }

        @Override
        public HandshakeStartResponseMessageBuilder receivedCount(long receivedCount) {
            this.receivedCount = receivedCount;
            return this;
        }

        @Override
        public short connectionId() {
            return this.connectionId;
        }

        @Override
        public String consistentId() {
            return this.consistentId;
        }

        @Override
        public UUID launchId() {
            return this.launchId;
        }

        @Override
        public long receivedCount() {
            return this.receivedCount;
        }

        @Override
        public HandshakeStartResponseMessage build() {
            return new HandshakeStartResponseMessageImpl(this.connectionId, this.consistentId, this.launchId, this.receivedCount);
        }
    }
}

