/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.rocksdb.configuration;

import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.storage.rocksdb.configuration.RocksDbDataRegionName;
import org.apache.ignite.internal.storage.rocksdb.configuration.schema.RocksDbStorageEngineConfiguration;
import org.apache.ignite.internal.storage.rocksdb.configuration.schema.RocksDbStorageEngineView;

public class RocksDbDataRegionValidatorImpl
implements Validator<RocksDbDataRegionName, String> {
    public static final RocksDbDataRegionValidatorImpl INSTANCE = new RocksDbDataRegionValidatorImpl();

    public void validate(RocksDbDataRegionName annotation, ValidationContext<String> ctx) {
        String dataRegion = (String)ctx.getNewValue();
        RocksDbStorageEngineView engineConfig = (RocksDbStorageEngineView)ctx.getNewRoot(RocksDbStorageEngineConfiguration.KEY);
        assert (engineConfig != null);
        if (!RocksDbDataRegionValidatorImpl.contains(engineConfig, dataRegion)) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), String.format("Unable to find data region '%s' in configuration '%s'", dataRegion, RocksDbStorageEngineConfiguration.KEY)));
        }
    }

    private static boolean contains(RocksDbStorageEngineView engineConfig, String dataRegion) {
        return engineConfig.defaultRegion().name().equals(dataRegion) || engineConfig.regions().get(dataRegion) != null;
    }
}

